(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['flip-through'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getRandomArray(array) {
	    array.sort(function () {
	        return .5 - Math.random();
	    });
	}

	var Card = (function (_super) {
	    tslib.__extends(Card, _super);
	    function Card(curLevel) {
	        var _this = _super.call(this) || this;
	        _this.curLevel = 1;
	        _this.curLevel = curLevel;
	        _this.addEventListener(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    Card.prototype.setup = function () {
	        var that = this;
	        that.removeEventListener(engine.Event.ADDED_TO_STAGE, this.setup, this);
	        that.cardState = false;
	        that.cardImg = new engine.Image();
	        that.addChild(that.cardImg);
	        var uuid = '';
	        switch (that.curLevel) {
	            case 1:
	                uuid = "d47b90ee-5295-4bd7-bb83-5fbd19a46e00";
	                break;
	            case 2:
	                uuid = "6af07fd2-9e73-4633-88fe-f963c6e23c4e";
	                break;
	            case 3:
	                uuid = "07586544-a854-4245-9ebf-d2b35d92be0e";
	                break;
	            default: console.log("卡牌初始化失败，当前关卡异常");
	        }
	        that.texture1 = getTexture(uuid);
	        that.cardImg.texture = that.texture1;
	        that.anchorX = that.cardImg.width >> 1;
	        that.anchorY = that.cardImg.height >> 1;
	    };
	    Card.prototype.setView = function (view) {
	        this.view = view;
	    };
	    Card.prototype.setCard = function (data) {
	        this.id = data.id;
	        this.texture2 = getTexture(data.texture);
	    };
	    Card.prototype.removeCard = function () {
	        var _this = this;
	        engine.Tween.get(this).to({ alpha: 0, rotation: 1800 }, 400).call(function () {
	            if (_this.parent && _this.parent.contains(_this)) {
	                _this.view.arrRemove(_this);
	                _this.parent.removeChild(_this);
	            }
	        });
	    };
	    Card.prototype.changeState = function () {
	        var _this = this;
	        var that = this;
	        return new Promise(function (resolve, reject) {
	            that.cardState = !that.cardState;
	            engine.Tween.removeTweens(_this);
	            if (!that.cardState) {
	                engine.Tween.get(_this).to({ scaleX: 0 }, 150).call(function () {
	                    that.cardImg.texture = that.texture1;
	                }).to({ scaleX: 1 }, 150).call(function () { resolve(); });
	            }
	            else {
	                engine.Tween.get(_this).to({ scaleX: 0 }, 150).call(function () {
	                    that.cardImg.texture = that.texture2;
	                }).to({ scaleX: 1 }, 150).call(function () { resolve(); });
	            }
	        });
	    };
	    return Card;
	}(engine.Sprite));

	var TestView = (function (_super) {
	    tslib.__extends(TestView, _super);
	    function TestView() {
	        var _this = _super.call(this) || this;
	        _this.cardArr = [];
	        _this.cardDataArr = [];
	        _this.imgArr1 = [];
	        _this.imgArr2 = [];
	        _this.imgArr3 = [];
	        _this.imgArr = [];
	        _this.cardDataArr1 = [];
	        _this.cardDataArr2 = [];
	        _this.cardDataArr3 = [];
	        _this.flipCardArr = [];
	        _this.curLevel = 1;
	        _this.canTimeCount = false;
	        _this.worldTime = 60;
	        _this.levelTime = 60;
	        _this.maxLevel = 3;
	        _this.offSet = [{ x: 85, y: 406 }, { x: 35, y: 462 }, { x: 61, y: 394 }];
	        _this.rowArr = [3, 4, 4];
	        _this.gap = [18, 14, 12];
	        _this.addEventListener(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    TestView.prototype.setup = function () {
	        var that = this;
	        that.removeEventListener(engine.Event.ADDED_TO_STAGE, that.setup, that);
	        that.imgArr1 = ["363286e4-6bf0-4061-ac84-b94818ce55de", "b4bd55f4-34ba-4745-863b-e129fee5bbfa", "e9f5feb6-9b99-4eb4-9c41-a57239a92b60", "666aa8d3-663a-497f-aeb6-3cff1cec9dfb", "d9be93c8-b6b5-4e03-ae31-a9136a0a551a", "b1947d26-1187-42d5-a98f-943bb2abd657"];
	        that.imgArr2 = ["f5d47e6a-0f14-4184-89ed-1bd3ad716ec9", "49e2d1ef-b0a3-4c71-94d2-833d406bf0ea", "9e94c64b-419b-47d2-8d27-8f52427d73b5", "26fe94fe-d30e-4f9c-be3e-e21a299792a4",
	            "416de8f2-d574-45a5-93dc-cbd5570e9a93", "796d4c04-13c8-4264-828e-7c447c3c2a0e", "e1be5e2d-dda0-418c-a87e-555d58c5634a", "bbdae2da-a08b-4cca-aed4-727ae41890e7"];
	        that.imgArr3 = ["cc6dd777-ca82-43dd-9a10-33412d70f226", "a64273b1-ec13-4444-84b3-5f17e9f9880b", "0d860f2b-06a7-41df-9345-a3b464ab5456", "7a8be191-24be-4381-a029-079dcf9c8894",
	            "3a5ca73c-121c-440b-849a-14aee2e59a9a", "b30aeb80-8e0a-4eac-b79d-611ebb83c590", "952007aa-451c-4ed5-bd39-61acbca556e0", "e8638bcd-c882-4f42-9ca8-c6d516b8bb8c", "cc24a1dc-a70d-48bc-b9c1-0e8214ccf62a", "46ff1f64-1e0a-4518-8a79-b5109abcc74e"];
	        that.imgArr = [that.imgArr1, that.imgArr2, that.imgArr3];
	        that.cardDataArr1 = [0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5];
	        that.cardDataArr2 = [0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7];
	        that.cardDataArr3 = [0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3, 4, 5, 6, 7, 9, 8, 9, 8];
	        that.cardDataArr = [that.cardDataArr1, that.cardDataArr2, that.cardDataArr3];
	        that.mouseChildren = false;
	        that.curLevel = 1;
	        that.canTimeCount = false;
	        that.levelTime = props.time;
	        that.worldTime = that.levelTime;
	        that.timeLable = new engine.Label();
	        that.addChild(that.timeLable);
	        that.timeLable.width = engine.gameStage.width;
	        that.timeLable.height = 34;
	        that.timeLable.textAlign = engine.TEXT_ALIGN.CENTER;
	        that.timeLable.size = 34;
	        that.timeLable.text = "时间：" + that.worldTime + ".00";
	        that.timeLable.x = 28;
	        that.timeLable.y = 308;
	        that.timeLable.fillColor = 0xffffff;
	        that.judgeFirstTimes();
	        that.setMap();
	        that.setTimer();
	        that.addEvnt();
	    };
	    TestView.prototype.addEvnt = function () {
	        engine.globalEvent.addEventListener("pictures-reset", this.resetGame, this);
	        engine.globalEvent.addEventListener("pictures-start", this.startLevel, this);
	    };
	    TestView.prototype.resetGame = function () {
	        var that = this;
	        that.curLevel = 1;
	        that.initNewLevel();
	    };
	    TestView.prototype.startLevel = function () {
	        var that = this;
	        that.canTimeCount = true;
	        that.mouseChildren = true;
	    };
	    TestView.prototype.initNewLevel = function () {
	        var that = this;
	        that.canTimeCount = false;
	        that.mouseChildren = false;
	        that.worldTime = that.levelTime;
	        that.timeLable.text = "时间：" + that.worldTime + ".00";
	        that.clearCardArr();
	        that.judgeFirstTimes();
	        that.setMap();
	    };
	    TestView.prototype.clearLevel = function () {
	        var that = this;
	        that.curLevel++;
	        if (that.curLevel > 3) {
	            engine.globalEvent.dispatchEvent("pictures-gameClear");
	            that.resetGame();
	        }
	        else {
	            engine.globalEvent.dispatchEvent("pictures-nextLevel", { level: that.curLevel });
	            that.initNewLevel();
	        }
	    };
	    TestView.prototype.judgeFirstTimes = function () {
	        var that = this;
	        if (localStorage.getItem("level" + that.curLevel)) {
	            getRandomArray(that.cardDataArr[that.curLevel - 1]);
	        }
	        else {
	            localStorage.setItem("level" + that.curLevel, '' + that.curLevel);
	        }
	    };
	    TestView.prototype.clearCardArr = function () {
	        var that = this;
	        for (var i = 0; i < that.cardArr.length; i++) {
	            var card = that.cardArr[i];
	            if (card && card.parent && card.parent.contains(card)) {
	                card.parent.removeChild(card);
	                that.cardArr.splice(i, 1);
	                i--;
	            }
	        }
	        that.flipCardArr.splice(0);
	    };
	    TestView.prototype.setMap = function () {
	        var that = this;
	        var dataArr = that.cardDataArr[that.curLevel - 1];
	        var row = that.rowArr[that.curLevel - 1];
	        var offsetX = that.offSet[that.curLevel - 1].x;
	        var offsetY = that.offSet[that.curLevel - 1].y;
	        var gap = that.gap[that.curLevel - 1];
	        for (var i = 0; i < dataArr.length; i++) {
	            var card = new Card(that.curLevel);
	            that.addChild(card);
	            var data = {
	                id: dataArr[i],
	                texture: that.imgArr[that.curLevel - 1][dataArr[i]]
	            };
	            card.setCard(data);
	            card.setView(that);
	            card.x = offsetX + i % row * (card.cardImg.width + gap);
	            card.y = offsetY + Math.floor(i / row) * (card.cardImg.height + gap);
	            card.addEventListener(engine.MouseEvent.CLICK, that.flipCard, that);
	            that.cardArr.push(card);
	        }
	    };
	    TestView.prototype.flipCard = function (e) {
	        return tslib.__awaiter(this, void 0, void 0, function () {
	            var that, card, card0, i;
	            return tslib.__generator(this, function (_a) {
	                switch (_a.label) {
	                    case 0:
	                        that = this;
	                        card = e.target;
	                        if (that.flipCardArr.indexOf(card) >= 0)
	                            return [2];
	                        if (!(that.flipCardArr.length < 1)) return [3, 1];
	                        that.flipCardArr.push(card);
	                        card.changeState();
	                        return [3, 6];
	                    case 1:
	                        if (!(that.flipCardArr.length < 2)) return [3, 5];
	                        that.flipCardArr.push(card);
	                        if (!that.flipCardArr[0]) return [3, 4];
	                        if (!(card.id == that.flipCardArr[0].id)) return [3, 3];
	                        card0 = that.flipCardArr[0];
	                        card.mouseEnabled = false;
	                        that.flipCardArr[0].mouseEnabled = false;
	                        that.flipCardArr.splice(0, that.flipCardArr.length);
	                        return [4, card.changeState()];
	                    case 2:
	                        _a.sent();
	                        card.removeCard();
	                        card0.removeCard();
	                        return [3, 4];
	                    case 3:
	                        card.changeState();
	                        _a.label = 4;
	                    case 4: return [3, 6];
	                    case 5:
	                        that.flipCardArr.push(card);
	                        card.changeState();
	                        for (i = 0; i < that.flipCardArr.length - 1; i++) {
	                            if (that.flipCardArr[i]) {
	                                that.flipCardArr[i].changeState();
	                                that.flipCardArr.splice(i, 1);
	                                i--;
	                            }
	                        }
	                        _a.label = 6;
	                    case 6: return [2];
	                }
	            });
	        });
	    };
	    TestView.prototype.arrRemove = function (obj) {
	        var index = this.cardArr.indexOf(obj);
	        if (index >= 0) {
	            this.cardArr.splice(index, 1);
	        }
	        if (this.cardArr.length <= 0) {
	            this.clearLevel();
	        }
	    };
	    TestView.prototype.setTimer = function () {
	        var _this = this;
	        setInterval(function () {
	            var that = _this;
	            if (!that.canTimeCount)
	                return;
	            that.worldTime = that.worldTime - 0.01;
	            if (that.worldTime <= 0) {
	                engine.globalEvent.dispatchEvent("pictures-gameFailed");
	                that.resetGame();
	            }
	            else {
	                var timeS = Math.floor(that.worldTime);
	                var timeSS = that.worldTime - timeS;
	                var string = timeSS.toFixed(2).split('.')[1];
	                that.timeLable.text = "时间：" + timeS + "." + string;
	            }
	        }, 10);
	    };
	    return TestView;
	}(engine.Container));

	var GameWrapper = (function (_super) {
	    tslib.__extends(GameWrapper, _super);
	    function GameWrapper() {
	        var _this = _super.call(this) || this;
	        engine.globalEvent.addEventListener("pictures-set", _this.set, _this);
	        var testView = _this._testView = new TestView();
	        _this.addChild(testView);
	        return _this;
	    }
	    GameWrapper.prototype.set = function (event) {
	        injectProps(event.data);
	        this._testView.set();
	    };
	    GameWrapper.prototype.start = function (event) {
	        injectProps(event.data);
	    };
	    GameWrapper.prototype.stop = function (event) {
	    };
	    return GameWrapper;
	}(engine.Container));

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new GameWrapper();
	    return instance;
	}

	return index;

})));

//# sourceMappingURL=main.js.map