declare module svga {
	export class BezierPath {
		_d: any;
		_transform: any;
		_styles: any;
		_shape: any;

		constructor(d?: any, transform?: any, styles?: any);
	}

	export class FrameEntity {
		alpha: number;
		transform: {
			a: number;
			b: number;
			c: number;
			d: number;
			tx: number;
			ty: number;
		};
		layout: {
			x: number;
			y: number;
			width: number;
			height: number;
		};
		nx: number;
		ny: number;
		/**
		 * BezierPath
		 */
		maskPath: any;
		/**
		 * Object[]
		 */
		shapes: any[];

		constructor(spec: any);

		static lastShapes: any;
	}

	export class SpriteEntity {
		/**
		 * string
		 */
		matteKey: any;
		/**
		 * string
		 */
		imageKey: any;
		/**
		 * FrameEntity[]
		 */
		frames: any[];

		constructor(spec: any);
	}

	export class VideoEntity extends engine.HashObject {
		/**
		 * SVGA 文件版本
		 */
		version: string;
		/**
		 * 影片尺寸
		 */
		videoSize: {
			width: number;
			height: number;
		};
		/**
		 * 帧率
		 */
		FPS: number;
		/**
		 * 帧数
		 */
		frames: number;
		/**
		 * Bitmaps
		 */
		images: {};
		/**
		 * 图片是否已被缓存，缓存全局，注意名字覆盖
		 */
		hasBeenCached: boolean;
		/**
		 * SpriteEntity[]
		 */
		sprites: SpriteEntity[];
		/**
		 * AudioEntity[]
		 */
		audios: any[];

		constructor(spec: any, images: any);

		resetSprites(spec: any): void;

		destroy(): void;
	}

	export class MovieClip extends engine.Container {
		/**
		 * 锁步将按时间间隔来执行动画
		 */
		lockStep: boolean;

		/**
		 * mc的当前帧,从1开始
		 * @property currentFrame
		 * @public
		 * @since 1.0.0
		 * @type {number}
		 * @default 1
		 * @readonly
		 */
		get currentFrame(): number;

		/**
		 * @property _curFrame
		 * @type {number}
		 * @private
		 * @since 2.0.0
		 * @default 1
		 */
		private _curFrame;

		/**
		 * 当前动画是否处于播放状态
		 * @property isPlaying
		 * @readOnly
		 * @public
		 * @since 1.0.0
		 * @type {boolean}
		 * @default true
		 * @readonly
		 */
		get isPlaying(): boolean;

		/**
		 * @property _isPlaying
		 * @type {boolean}
		 * @private
		 * @since 2.0.0
		 * @default true
		 */
		private _isPlaying;

		/**
		 * 动画的播放方向,是顺着播还是在倒着播
		 * @property isFront
		 * @public
		 * @since 1.0.0
		 * @type {boolean}
		 * @default true
		 * @readonly
		 */
		get isFront(): boolean;

		/**
		 * @property _isFront
		 * @type {boolean}
		 * @private
		 * @default true
		 */
		private _isFront;
		/**
		 * 当前动画的总帧数
		 * @property totalFrames
		 * @public
		 * @since 1.0.0
		 * @type {number}
		 * @default 1
		 * @readonly
		 */
		totalFrames: number;
		loops: number;
		/**
		 * 所有textures缓存
		 */
		private textures;
		/**
		 * 锁步的时间间隔，按fps定,毫秒
		 */
		private timeInterval;
		/**
		 * 前提引擎按60设置
		 */
		private deltaFrame;
		/**
		 * 中间帧计时
		 */
		private frameCount;

		/**
		 * 构造函数
		 * @method MovieClip
		 * @public
		 * @since 1.0.0
		 */
		constructor(mv?: VideoEntity);

		/**
		 * 可以手动用init，
		 * @param mv
		 */
		init(mv: VideoEntity): void;

		private initChildren;
		/**
		 * 用基础属性重置
		 * @param display
		 * @param transform
		 */
		private resetTransform;

		/**
		 * 用基础属性重置所有的待frame的children
		 * @param frameIndex 帧 1到total
		 */
		resetTransformAll(frameIndex: number): void;

		/**
		 *
		 * @param imagekey 对应的imagekey
		 * @param imageUrl 图片路径，以后考虑支持多种形式
		 */
		setImage(imagekey: any, imageUrl: string): void;

		/**
		 * 调用止方法将停止当前帧
		 * @method stop
		 * @public
		 * @since 1.0.0
		 */
		stop(): void;

		/**
		 * 将播放头向后移一帧并停在下一帧,如果本身在最后一帧则不做任何反应
		 * @method nextFrame
		 * @since 1.0.0
		 * @public
		 */
		nextFrame(): void;

		/**
		 * 将播放头向前移一帧并停在下一帧,如果本身在第一帧则不做任何反应
		 * @method prevFrame
		 * @since 1.0.0
		 * @public
		 */
		prevFrame(): void;

		/**
		 * 将播放头跳转到指定帧并停在那一帧,如果本身在第一帧则不做任何反应
		 * @method gotoAndStop
		 * @public
		 * @since 1.0.0
		 * @param {number} frameIndex 批定帧的帧数或指定帧的标签名
		 */
		gotoAndStop(frameIndex: number): void;

		/**
		 * 如果当前时间轴停在某一帧,调用此方法将继续播放.
		 * @method play
		 * @public
		 * @since 1.0.0
		 */
		play(isFront?: boolean, loop?: boolean): void;

		/**
		 * @property _lastFrame
		 * @type {number}
		 * @private
		 * @default 0
		 */
		private _lastFrame;

		/**
		 * 刚执行到的帧数，用于帧监听时判断用，刚好执行到当前帧，而不是之前保留的状态
		 * 不是60fps的videoItem的中间有几帧curFrame会不变，判断只执行一次监听时会出错，刚好动画满帧60fps时就无所谓
		 */
		get isInTimeFrame(): boolean;

		/**
		 * 将播放头跳转到指定帧并从那一帧开始继续播放
		 * @method gotoAndPlay
		 * @public
		 * @since 1.0.0
		 * @param {number} frameIndex 批定帧的帧数或指定帧的标签名
		 * @param {boolean} isFront 跳到指定帧后是向前播放, 还是向后播放.不设置些参数将默认向前播放
		 */
		gotoAndPlay(frameIndex: number, isFront?: boolean): void;

		/**
		 * 优先级最高，会覆盖
		 * @param beginFrame 默认1
		 * @param endFrame 默认 this.totalFrames
		 * @param loops 默认1 0
		 */
		startAniRange(beginFrame?: number, endFrame?: number, loops?: number, callback?: Function): void;

		/**
		 * 开始时间，每次有play的时候就需要重置now
		 * 锁步思想，设置开始时间，后面每帧实际时间与开始时间相减，得到当前帧数
		 *
		 */
		private startTime;
		/**
		 * 开始时的frame
		 */
		private startFrame;
		/**
		 * 与startFrame相间隔的帧数量，绝对值
		 */
		private lastDeltaFrame;
		/**
		 * 锁步时的每次end的标识
		 */
		private _endMark;
		commonDeltaTime: number;

		updateFrame(): void;

		private getCurFrameWhenLockStep;

		/**
		 * 重写刷新
		 * @method update
		 * @public
		 * @since 1.0.0
		 */
		update(deltaTime: number): void;

		destroy(): void;
	}

	export class Svga extends MovieClip {
		private _source;
		autoPlay: boolean;

		get source(): string;
		set source(v: string);

		private _setSource;
		private _dataInitialized;
	}

	export class Parser {
		/**
		 * url: 资源路径
		 * success(VideoEntity videoItem)
		 */
		load(url, success, failure);

		loadViaWorker(url, success, failure);
	}
}
