"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var injectProp = engine.injectProp;
var BuriedPoint = (function (_super) {
    __extends(BuriedPoint, _super);
    function BuriedPoint() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dpm = 'appID.0.0.0';
        _this.dcm = '202.projectID.0.0';
        _this.dom = '0.0.0.0';
        _this.autoExposure = true;
        _this.onceAutoExposure = false;
        _this.autoExposureType = 'visible';
        _this.autoClick = true;
        _this.checkFps = 5;
        _this._autoExposured = false;
        _this._hostVisible = false;
        _this.checkVisibility = function () {
            var worldVisible = _this.host.worldVisible;
            if (worldVisible !== _this._hostVisible) {
                _this._hostVisible = worldVisible;
                if (worldVisible) {
                    _this._onVisible();
                }
            }
        };
        return _this;
    }
    BuriedPoint.prototype.onModify = function (value, key, oldValue) {
        switch (key) {
            case 'dpm':
            case 'dcm':
            case 'dom':
                this['__' + key] = fill(value);
                break;
        }
    };
    BuriedPoint.prototype.mounted = function () {
        this.host.addEventListener(engine.MouseEvent.CLICK, this._onClick, this);
        this._timer = setInterval(this.checkVisibility, 1000 / this.checkFps);
    };
    BuriedPoint.prototype.destroy = function () {
        this.host.removeEventListener(engine.MouseEvent.CLICK, this._onClick, this);
        if (this._timer) {
            clearInterval(this._timer);
            this._timer = null;
        }
    };
    BuriedPoint.prototype.awake = function () {
        if (this.autoExposure && this.autoExposureType === 'awake') {
            this.autoLogExposure();
        }
    };
    BuriedPoint.prototype._onVisible = function (e) {
        if (e === void 0) { e = null; }
        if (this.autoExposure && this.autoExposureType === 'visible') {
            this.autoLogExposure();
        }
    };
    BuriedPoint.prototype.autoLogExposure = function () {
        if (!this._autoExposured) {
            if (this.onceAutoExposure) {
                this._autoExposured = true;
            }
            this.logExposure();
        }
    };
    BuriedPoint.prototype._onClick = function (e) {
        if (this.autoClick) {
            this.logClick();
        }
    };
    BuriedPoint.prototype.logExposure = function () {
        this.log('exposure');
    };
    BuriedPoint.prototype.logClick = function () {
        this.log('click');
    };
    BuriedPoint.prototype.log = function (type) {
        return __awaiter(this, void 0, void 0, function () {
            var otherQuery;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        otherQuery = {
                            appId: engine.env.appID,
                        };
                        return [4, log(type, {
                                dpm: this['__dpm'],
                                dcm: this['__dcm'],
                                dom: this['__dom'],
                            }, otherQuery)];
                    case 1:
                        _a.sent();
                        if (this.id !== undefined) {
                            engine.globalEvent.dispatchEvent('buried-point-success', {
                                type: type,
                                id: this.id,
                            });
                        }
                        return [2];
                }
            });
        });
    };
    BuriedPoint.id = 'buried-point';
    __decorate([
        engine.dirtyFieldTrigger
    ], BuriedPoint.prototype, "dpm", void 0);
    __decorate([
        engine.dirtyFieldTrigger
    ], BuriedPoint.prototype, "dcm", void 0);
    __decorate([
        engine.dirtyFieldTrigger
    ], BuriedPoint.prototype, "dom", void 0);
    return BuriedPoint;
}(engine.ScriptBase));
exports.default = BuriedPoint;
function fill(src) {
    var result = src;
    for (var key_1 in engine.env) {
        result = result.replace(key_1, engine.env[key_1]);
    }
    return result;
}
function log(type, data, otherQuery) {
    var dpm = data.dpm, dcm = data.dcm, dom = data.dom;
    var params = {
        dpm: dpm, dcm: dcm,
    };
    if (dom !== '0.0.0.0') {
        params.dom = dom;
    }
    injectProp(params, otherQuery);
    var isExposure = type === 'exposure';
    return engine.httpRequest(isExposure ? '//embedlog.duiba.com.cn/exposure/standard' : '/log/click', 'get', params, isExposure ? 'jsonp' : 'text');
}
