"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../utils");
var factor = 10;
var Head = (function (_super) {
    __extends(Head, _super);
    function Head() {
        var _this = _super.call(this) || this;
        _this.imgFace = new engine.Sprite(utils_1.getTextureByName('head_0'));
        _this.addChild(_this.imgFace);
        _this.imgFace.anchorTexture.set(107 / _this.imgFace.width, 155 / _this.imgFace.height);
        _this.imgFace.y = 65;
        _this._headType = '';
        return _this;
    }
    Head.prototype.localUpdate = function (x, y, rotation, sleeping) {
        this.x = x;
        this.y = y;
        this.rotation = rotation;
    };
    Object.defineProperty(Head.prototype, "fWidth", {
        get: function () {
            return this.width / factor;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Head.prototype, "fHeight", {
        get: function () {
            return this.height / factor;
        },
        enumerable: true,
        configurable: true
    });
    Head.prototype.switchFace = function (type, playAni) {
        if (type == this._headType) {
            return;
        }
        var headName = '';
        if (type == 'normal') {
            headName = 'head_0';
        }
        else if (type == 'happy') {
            headName = 'head_1';
        }
        else if (type == 1 || type == 0 || type == 2) {
            headName = 'head_2';
        }
        else if (type == 3) {
            headName = 'head_3';
        }
        else if (type == 4) {
            headName = 'head_4';
        }
        this._headType = type;
        this.imgFace.texture = utils_1.getTextureByName(headName);
    };
    return Head;
}(engine.Container));
exports.Head = Head;
