"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GameView_1 = require("./GameView");
var props_1 = require("../props");
var GameWrapper = (function (_super) {
    __extends(GameWrapper, _super);
    function GameWrapper() {
        var _this = _super.call(this) || this;
        engine.globalEvent.addEventListener('walking-cat-start', _this.start, _this);
        engine.globalEvent.addEventListener('walking-cat-revive', _this.revive, _this);
        engine.globalEvent.addEventListener('walking-cat-showScore', _this.revive, _this);
        var gameView = _this._gameView = new GameView_1.default();
        _this.addChild(gameView);
        return _this;
    }
    GameWrapper.prototype.start = function (event) {
        props_1.injectProps(event.data);
        this._gameView.eventStart();
    };
    GameWrapper.prototype.revive = function () {
        console.log('复活');
        this._gameView.reset(true);
        this._gameView.start(true);
    };
    return GameWrapper;
}(engine.Container));
exports.GameWrapper = GameWrapper;
