"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var MConfigs_1 = require("../Global/MConfigs");
var MConst_1 = require("../Global/MConst");
var utils_1 = require("../utils");
var props_1 = require("../../props");
var padding = 10;
var GuideMask = (function (_super) {
    __extends(GuideMask, _super);
    function GuideMask(index, x1, y1) {
        var _this = _super.call(this) || this;
        var config = MConfigs_1.MConfigs.guide[index];
        var mask = new engine.Sprite(utils_1.getTexture("3cc0aa86-0581-4caa-b662-266e58fd39b7"));
        var w = mask.width, h = mask.height;
        x1 = Math.floor(x1);
        y1 = Math.floor(y1);
        var x = x1 - w / 2;
        var y = y1 - h / 2;
        mask.x = x;
        mask.y = y;
        _this.addChild(mask);
        var sw = MConst_1.MConst.DesignResolution.width, sh = MConst_1.MConst.DesignResolution.height;
        var color = 0x000000;
        var alpha = 0.7;
        var top = new engine.Shape();
        top.beginFill(color, alpha);
        top.drawRect(0, -sh, sw, y + sh);
        top.endFill();
        _this.addChild(top);
        var bottom = new engine.Shape();
        bottom.beginFill(color, alpha);
        bottom.drawRect(x, y + h, w, sh - h - y);
        bottom.endFill();
        _this.addChild(bottom);
        var left = new engine.Shape();
        left.beginFill(color, alpha);
        left.drawRect(0, y, x, sh - y);
        left.endFill();
        _this.addChild(left);
        var right = new engine.Shape();
        right.beginFill(color, alpha);
        right.drawRect(x + w, y, sw - x - w, sh - y);
        right.endFill();
        _this.addChild(right);
        var offsetToMask = config.text.offsetToMask;
        var label = new engine.Label();
        label.text = props_1.props['guideText' + index];
        label.size = 24;
        label.fillColor = "rgba(255,255,255,1)";
        label.x = mask.x + (w - label.width) / 2;
        label.y = offsetToMask.y + mask.y;
        _this.addChild(label);
        if (index == 0) {
            var left_1 = new engine.Sprite(utils_1.getTexture("93992a62-e3c4-46d5-99f4-f7ba35fe4f4f"));
            left_1.x = x1 + 200;
            left_1.y = y1 - left_1.height / 2;
            _this.addChild(left_1);
            var right_1 = new engine.Sprite(utils_1.getTexture("93992a62-e3c4-46d5-99f4-f7ba35fe4f4f"));
            right_1.x = x1 - 200;
            right_1.scaleX = -1;
            right_1.y = y1 - right_1.height / 2;
            _this.addChild(right_1);
        }
        if (label.x < padding) {
            label.x = padding;
        }
        else if (label.x + label.width > 750 - padding) {
            label.x = 750 - label.width - padding;
        }
        _this.addEventListener(engine.MouseEvent.MOUSE_DOWN, function () {
            _this.onClick && _this.onClick(_this);
        }, _this);
        return _this;
    }
    return GuideMask;
}(engine.Container));
exports.default = GuideMask;
