"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GameObject = (function (_super) {
    __extends(GameObject, _super);
    function GameObject() {
        var _this = _super.call(this) || this;
        _this.name = "";
        _this.componentList = [];
        _this.mouseEnabled = false;
        _this.mouseChildren = false;
        return _this;
    }
    GameObject.prototype.addComponent = function (cls) {
        if (this.getComponent(cls) != null) {
            console.error("component is existent");
            return;
        }
        var ins = new cls(this);
        ins.enabled = true;
        this.componentList.push(ins);
        return ins;
    };
    GameObject.prototype.getComponent = function (cls) {
        for (var _i = 0, _a = this.componentList; _i < _a.length; _i++) {
            var i = _a[_i];
            if (i instanceof cls) {
                return i;
            }
        }
        return null;
    };
    GameObject.prototype.removeComponent = function (cls) {
        var _loop_1 = function (i) {
            if (i instanceof cls) {
                i.enabled = false;
                this_1.componentList = this_1.componentList.filter(function (e) { return e != i; });
                return { value: void 0 };
            }
        };
        var this_1 = this;
        for (var _i = 0, _a = this.componentList; _i < _a.length; _i++) {
            var i = _a[_i];
            var state_1 = _loop_1(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
    };
    GameObject.prototype.dispose = function () {
        this.destroy();
        this.disableAllComponents();
    };
    GameObject.prototype.disableAllComponents = function () {
        var _this = this;
        Object.keys(this.componentList).forEach(function (e) { return _this.componentList[e].enabled = false; });
    };
    GameObject.prototype.enableAllComponents = function () {
        var _this = this;
        Object.keys(this.componentList).forEach(function (e) { return _this.componentList[e].enabled = true; });
    };
    GameObject.prototype.onCollisionEnter = function (other) {
    };
    GameObject.prototype.onCollisionStay = function (other) {
    };
    GameObject.prototype.onCollisionExit = function (other) {
    };
    return GameObject;
}(engine.Container));
exports.default = GameObject;
