"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Block_1 = require("./Block");
var Background_1 = require("./Background");
var Player_1 = require("./Player");
var props_1 = require("../props");
var utils_1 = require("./utils");
var Base_1 = require("./Base");
var GuideLayer_1 = require("./GuideLayer");
var GoldBag_1 = require("./GoldBag");
var ObjectPool = engine.ObjectPool;
var PoolName = 'gold-bag';
ObjectPool.registerPool(PoolName, function () {
    return new GoldBag_1.GoldBag();
}, function (item, data) {
    item.reset(data);
});
var GameView = (function (_super) {
    __extends(GameView, _super);
    function GameView() {
        var _this = _super.call(this) || this;
        _this.index = -1;
        _this.goldBags = [];
        _this.baseOffset = -props_1.props.baseOffset + props_1.props.playerOffset;
        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
        return _this;
    }
    GameView.prototype.setup = function () {
        if (this._hasSetup) {
            return;
        }
        this._hasSetup = true;
        var _a = this.stage, width = _a.width, height = _a.height;
        var background = this.background = new Background_1.Background();
        this.addChild(background);
        background.setup();
        var frontContainer = this.frontContainer = new engine.Container();
        frontContainer.x = width / 2;
        this.addChild(frontContainer);
        var guideLayer = this.guideLayer = new GuideLayer_1.GuideLayer();
        this.addChild(guideLayer);
        var base = this.base = new Base_1.Base();
        frontContainer.addChild(base);
        base.setup();
        var blockContainer = this.blockContainer = new engine.Container();
        frontContainer.addChild(blockContainer);
        var player = this.player = new Player_1.default();
        frontContainer.addChild(player);
        player.setup();
        player.addEventListener('jump-on-top', this.onPlayerJumpOnTop, this);
        ObjectPool.recycleObject(PoolName, ObjectPool.getObject(PoolName, {
            y: 0,
            remain: 0,
        }));
        this.hitEffect = utils_1.createSvga('被撞烟雾', 'hitEffectAnchor');
        this.pos = 0;
        this.background.setup();
        this.addEventListener(engine.Event.ENTER_FRAME, this.onEnterFrame, this);
        this.reset();
    };
    GameView.prototype.reset = function (revive) {
        if (revive === void 0) { revive = false; }
        return __awaiter(this, void 0, void 0, function () {
            var blockContainer, i, li, block, i, i, li, goldBag;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.base.reset();
                        this.index = -1;
                        this._score = 0;
                        if (revive) {
                        }
                        else {
                            this.pos = 0;
                            blockContainer = this.blockContainer;
                            for (i = 0, li = blockContainer.children.length; i < li; i++) {
                                block = blockContainer.getChildAt(i);
                                block.playLeave();
                            }
                        }
                        for (i = 0; i < props_1.props.initBlockCount; i++) {
                            this.addBlock(false);
                        }
                        for (i = 0, li = this.goldBags.length; i < li; i++) {
                            goldBag = this.goldBags[i];
                            this.frontContainer.removeChild(goldBag);
                            ObjectPool.recycleObject(PoolName, goldBag);
                        }
                        this.goldBags.splice(0);
                        this.playZoom('in');
                        return [4, this.resetPlayer(revive)];
                    case 1:
                        _a.sent();
                        return [2];
                }
            });
        });
    };
    GameView.prototype.resetPlayer = function (revive) {
        if (revive === void 0) { revive = false; }
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.player.reset(revive);
                this.player.y = this.baseOffset - (this.index + 1) * props_1.props.blockHitHeight;
                return [2];
            });
        });
    };
    GameView.prototype.start = function (revive) {
        if (revive === void 0) { revive = false; }
        return __awaiter(this, void 0, void 0, function () {
            var guideFlagKey, guideFlag;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!!revive) return [3, 2];
                        return [4, this.player.playReady()];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2:
                        guideFlagKey = 'jump-high-guide_' + props_1.props.guideFlagKey;
                        guideFlag = localStorage.getItem(guideFlagKey);
                        if (!!guideFlag) return [3, 4];
                        localStorage.setItem(guideFlagKey, '1');
                        return [4, this.guideLayer.show('', { y: this.stage.height + this.player.y - 280 })];
                    case 3:
                        _a.sent();
                        _a.label = 4;
                    case 4:
                        this.lastLandType = 0;
                        this._remainToShowGoldBag = props_1.props.goldBagScoreMultiple - props_1.props.goldBagScoreSubtraction;
                        this._touchEnabled = true;
                        setTimeout(function () {
                            _this.addBlock();
                        }, 100);
                        engine.globalEvent.dispatchEvent('jump-high-game-start');
                        return [2];
                }
            });
        });
    };
    GameView.prototype.pause = function () {
        if (this.currentBlock) {
            engine.Tween.pauseTweens(this.currentBlock);
        }
        engine.Tween.pauseTweens(this.player);
    };
    GameView.prototype.resume = function () {
        if (this.currentBlock) {
            engine.Tween.resumeTweens(this.currentBlock);
        }
        engine.Tween.resumeTweens(this.player);
    };
    GameView.prototype.revive = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.blockContainer.getChildAt(this.index).visible = false;
                        this.index--;
                        return [4, this.resetPlayer(true)];
                    case 1:
                        _a.sent();
                        return [4, this.playZoom('in')];
                    case 2:
                        _a.sent();
                        this.start(true);
                        return [2];
                }
            });
        });
    };
    GameView.prototype.addBlock = function (animation) {
        var _this = this;
        if (animation === void 0) { animation = true; }
        this.index++;
        var blockContainer = this.blockContainer;
        var block;
        if (blockContainer.children.length > this.index) {
            block = blockContainer.getChildAt(this.index);
            block.visible = true;
        }
        else {
            block = new Block_1.default();
            blockContainer.addChild(block);
        }
        block.reset({
            type: Math.floor(Math.random() * props_1.props.blockAssets.length),
        });
        block.y = this.baseOffset - this.index * props_1.props.blockHitHeight;
        this.blockComplete = false;
        block.playEnter(this.index, animation).then(function (data) {
            _this.blockComplete = true;
        });
        if (animation) {
            this.needHitTest = true;
        }
        this.currentBlock = block;
    };
    GameView.prototype.addGoldBag = function () {
        var goldBag = ObjectPool.getObject(PoolName, {
            y: this.baseOffset - (this.blockCount + props_1.props.goldBagDistance + props_1.props.goldBagJumpSubtraction) * props_1.props.blockHitHeight,
            remain: props_1.props.goldBagDistance,
        });
        this.frontContainer.addChild(goldBag);
        this.goldBags.push(goldBag);
    };
    GameView.prototype.playOpenGoldBag = function () {
        return __awaiter(this, void 0, void 0, function () {
            var i, li, goldBag;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        i = 0, li = this.goldBags.length;
                        _a.label = 1;
                    case 1:
                        if (!(i < li)) return [3, 4];
                        goldBag = this.goldBags[i];
                        goldBag.remain--;
                        if (!(goldBag.remain <= 0)) return [3, 3];
                        this.goldBags.splice(i, 1);
                        i--;
                        li--;
                        this.nextToUpdateScore = true;
                        return [4, goldBag.playOpen()];
                    case 2:
                        _a.sent();
                        this.frontContainer.removeChild(goldBag);
                        ObjectPool.recycleObject(PoolName, goldBag);
                        _a.label = 3;
                    case 3:
                        i++;
                        return [3, 1];
                    case 4: return [2];
                }
            });
        });
    };
    GameView.prototype.onPlayerJumpOnTop = function () {
        if (this.nextToUpdateScore) {
            this.nextToUpdateScore = false;
            this.scoreChange(4);
            utils_1.playSound('撞击钱袋音效');
        }
    };
    Object.defineProperty(GameView.prototype, "blockCount", {
        get: function () {
            return this.index - props_1.props.initBlockCount + 1;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GameView.prototype, "pos", {
        get: function () {
            return this._pos;
        },
        set: function (v) {
            this._pos = v;
            this.updatePos();
        },
        enumerable: true,
        configurable: true
    });
    GameView.prototype.updatePos = function () {
        this.frontContainer.y = this.stage.height + this._pos;
    };
    GameView.prototype.onEnterFrame = function (event) {
        if (this.needHitTest) {
            if (this.currentBlock) {
                var _a = this.currentBlock, bx = _a.x, by = _a.y, dir = _a.dir;
                var _b = this.player, px = _b.x, py = _b.y;
                var blockHitWidth = props_1.props.blockHitWidth, blockHitHeight = props_1.props.blockHitHeight, playerWidth = props_1.props.playerWidth;
                var hitOn = false;
                if (Math.abs(px - bx) < (blockHitWidth + playerWidth) / 2) {
                    this.player.changeBaseY(by - blockHitHeight);
                    if (py > by - blockHitHeight) {
                        hitOn = true;
                    }
                }
                if (hitOn) {
                    this.onHitOn(dir);
                }
            }
        }
    };
    GameView.prototype.onHitOn = function (dir) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this._touchEnabled = false;
                        this.needHitTest = false;
                        clearInterval(this.timer);
                        this.currentBlock.stop();
                        this.playHitEffect(dir);
                        return [4, this.player.hitAway(dir)];
                    case 1:
                        _a.sent();
                        this.playZoom('out');
                        return [4, this.player.parachute(dir)];
                    case 2:
                        _a.sent();
                        engine.globalEvent.dispatchEvent('jump-high-game-end');
                        return [2];
                }
            });
        });
    };
    GameView.prototype.jump = function () {
        return __awaiter(this, void 0, void 0, function () {
            var result, pos, type_1, lastLandType;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this._touchEnabled) {
                            return [2];
                        }
                        this._touchEnabled = false;
                        this.playOpenGoldBag();
                        return [4, this.player.jump()];
                    case 1:
                        result = _a.sent();
                        if (!result) return [3, 5];
                        if (!result.aboveBlock) return [3, 4];
                        pos = Math.abs(this.currentBlock.x);
                        type_1 = 0;
                        if (pos > 0) {
                            type_1 = pos > 0 && pos < props_1.props.scoreThreshold ? 2 : 3;
                        }
                        lastLandType = this.lastLandType;
                        this.lastLandType = type_1;
                        if (type_1 === 0) {
                            if (lastLandType !== type_1) {
                                type_1 = 1;
                            }
                        }
                        if (type_1 < 3) {
                            this.currentBlock.playEffect();
                        }
                        this.player.playLand(type_1, this.currentBlock.dir);
                        this.currentBlock.stop();
                        this.scoreChange(type_1);
                        return [4, this.playShake()];
                    case 2:
                        _a.sent();
                        return [4, new Promise(function (resolve) {
                                engine.Tween.get(_this, null, null, true)
                                    .to({ pos: props_1.props.blockHitHeight * _this.index }, 300, engine.Ease.cubicOut)
                                    .call(resolve);
                            })];
                    case 3:
                        _a.sent();
                        this.addBlock();
                        _a.label = 4;
                    case 4:
                        this._touchEnabled = true;
                        _a.label = 5;
                    case 5: return [2];
                }
            });
        });
    };
    GameView.prototype.scoreChange = function (type) {
        var scoreAdd = props_1.props.scoreWeights[type];
        this._score += scoreAdd;
        this._remainToShowGoldBag -= scoreAdd;
        var score = this._score;
        engine.globalEvent.dispatchEvent('jump-high-score', {
            type: type,
            score: score,
            scoreAdd: scoreAdd,
        });
        console.log(score, this._remainToShowGoldBag);
        if (this._remainToShowGoldBag <= 0) {
            this._remainToShowGoldBag += props_1.props.goldBagScoreMultiple;
            this.addGoldBag();
            console.log('addGoldBag');
        }
    };
    GameView.prototype.playHitEffect = function (dir) {
        var hitEffect = this.hitEffect;
        hitEffect.scaleX = dir;
        hitEffect.y = this.player.y - props_1.props.hitEffectAnchor.y;
        hitEffect.play(true, false);
        hitEffect.once(engine.Event.END_FRAME, function () {
            this.frontContainer.removeChild(hitEffect);
        }, this);
        this.frontContainer.addChild(hitEffect);
    };
    GameView.prototype.playZoom = function (type, duration) {
        var _this = this;
        if (duration === void 0) { duration = 700; }
        this.background.playZoom(type, duration);
        var count = this.stage.height / props_1.props.blockHitHeight;
        return new Promise(function (resolve) {
            _this.frontContainer.anchorY = -props_1.props.blockHitHeight * (_this.index + count * 1.3) + props_1.props.baseOffset;
            var scale = type === 'in' ? 1 : Math.min((_this.stage.height / props_1.props.blockHitHeight / (_this.index + count)), props_1.props.maxScale);
            console.log(scale);
            engine.Tween.get(_this.frontContainer, null, null, true)
                .to({ scaleX: scale, scaleY: scale }, duration, engine.Ease.cubicInOut)
                .call(resolve);
        });
    };
    GameView.prototype.playShake = function () {
        var _this = this;
        var _a = this.frontContainer, x = _a.x, y = _a.y;
        let a = '';
        a.substr
        return new Promise(function (resolve) {
            var shakeOffset = 7;
            var duration = 30;
            engine.Tween.get(_this.frontContainer, null, null, true)
                .to({ x: x, y: y - shakeOffset }, duration)
                .to({ x: x, y: y + shakeOffset }, duration)
                .to({ x: x + shakeOffset, y: y }, duration)
                .to({ x: x - shakeOffset, y: y }, duration)
                .to({ x: x, y: y }, duration)
                .call(resolve);
        });
    };
    return GameView;
}(engine.Container));
exports.default = GameView;
