"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("./../props");
var utils_1 = require("./utils");
var Pier = (function (_super) {
    __extends(Pier, _super);
    function Pier() {
        var _this = _super.call(this) || this;
        _this.bmp = new engine.Sprite();
        _this.addChild(_this.bmp);
        return _this;
    }
    Pier.prototype.init = function () {
        var bmp = this.bmp;
        bmp.alpha = 1;
        bmp.texture = utils_1.getTextureByName('pier');
        bmp.x = 0;
        bmp.y = bmp.height;
        if (this.children.length < 2) {
            var gold = new engine.Sprite();
            gold.texture = utils_1.getTextureByName('gold');
            gold.name = 'gold';
            this.addChild(gold);
        }
        this.setGoldPosX(bmp);
        this.setShowGold();
    };
    Pier.prototype.setShowGold = function () {
        var nodeGold = this.getChildByName('gold');
        var randomWard = Math.random();
        nodeGold.alpha = 1;
        var isShow = randomWard < props_1.props.reward ? true : false;
        nodeGold.visible = isShow;
        this.haveGold = isShow;
    };
    Pier.prototype.setGoldPosX = function (bmp) {
        var nodeGold = this.getChildByName('gold');
        var pos = bmp.width / 2 - nodeGold.width / 2;
        nodeGold.x = pos;
        nodeGold.y = bmp.height - nodeGold.height - 50;
        nodeGold.visible = false;
    };
    Pier.prototype.closeGold = function () {
        var _this = this;
        this.children.forEach(function (item) {
            if (item.name == 'gold') {
                item.anchorX = item.width / 2;
                item.anchorY = item.height / 2;
                engine.Tween.get(item, { loop: false })
                    .to({ scaleX: 2.5, scaleY: 2.5 }, 200, engine.Ease.cubicOut)
                    .to({ scaleX: 1, scaleY: 1, alpha: 0 }, 200, engine.Ease.cubicIn)
                    .call(function () {
                    item.visible = false;
                    _this.haveGold = false;
                });
            }
        });
    };
    return Pier;
}(engine.Container));
exports.Pier = Pier;
