"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var props_1 = require("../props");
var FrontBoxs = (function (_super) {
    __extends(FrontBoxs, _super);
    function FrontBoxs() {
        var _this = _super.call(this) || this;
        _this.frontBoxs = [];
        return _this;
    }
    FrontBoxs.prototype.setup = function () {
        var initX, initY = 0;
        this.box1 = new engine.Sprite(utils_1.getTextureByName("狗盒"));
        this.box1["npcType"] = "box1";
        initX = this.box1.x = 435;
        initY = this.box1.y = 614;
        this.box2 = new engine.Sprite(utils_1.getTextureByName("猫盒"));
        this.box2["npcType"] = "box2";
        this.box3 = new engine.Sprite(utils_1.getTextureByName("草泥马盒"));
        this.box3["npcType"] = "box3";
        this.box4 = new engine.Sprite(utils_1.getTextureByName("狗盒"));
        this.box4["npcType"] = "box4";
        this.box5 = new engine.Sprite(utils_1.getTextureByName("猫盒"));
        this.box5["npcType"] = "box5";
        this.frontBoxs = [this.box1, this.box2, this.box3, this.box4];
        for (var i = 0; i < this.frontBoxs.length; i++) {
            if (i == 0) {
                this.frontBoxs[i].x = initX;
            }
            else {
                this.frontBoxs[i].x = this.frontBoxs[i - 1].x - this.box1.width - props_1.props.frontmargin;
            }
            this.frontBoxs[i].y = initY;
            this.addChild(this.frontBoxs[i]);
        }
        this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
    };
    FrontBoxs.prototype.frameMove = function () {
        var _this = this;
        this.frontBoxs.forEach(function (item, index) {
            item.x += props_1.props.moveSpeed;
            if (item.x <= 0 && !item.visible) {
                item.visible = true;
            }
            if (item.x >= 750) {
                var lastitem = _this.frontBoxs.shift();
                lastitem.x = _this.frontBoxs[_this.frontBoxs.length - 1].x - _this.box1.width - props_1.props.frontmargin;
                if (!_this.GameView.getMoveX() && item.x <= 0 && _this.GameView.startstatus) {
                    _this.GameView.setMoveX((370 - item.x - 13) / props_1.props.moveSpeed, item);
                    _this.hideBox = item;
                }
                _this.frontBoxs.push(lastitem);
            }
        });
    };
    FrontBoxs.prototype.stop = function () {
    };
    FrontBoxs.prototype.showHidePrizeBox = function (isshow) {
        this.hideBox.visible = isshow;
    };
    return FrontBoxs;
}(engine.Container));
exports.FrontBoxs = FrontBoxs;
