"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var props_1 = require("../props");
var BackBoxs = (function (_super) {
    __extends(BackBoxs, _super);
    function BackBoxs() {
        var _this = _super.call(this) || this;
        _this.backBoxs = [];
        return _this;
    }
    BackBoxs.prototype.setup = function () {
        var initX, initY = 0;
        this.box1 = new engine.Sprite(utils_1.getTextureByName("后狗盒"));
        initX = this.box1.x = 188;
        initY = this.box1.y = 616;
        this.box2 = new engine.Sprite(utils_1.getTextureByName("后猫盒"));
        this.box3 = new engine.Sprite(utils_1.getTextureByName("后草泥马盒"));
        this.box4 = new engine.Sprite(utils_1.getTextureByName("后狗盒"));
        this.box5 = new engine.Sprite(utils_1.getTextureByName("后猫盒"));
        this.backBoxs = [this.box1, this.box2, this.box3, this.box4, this.box5];
        for (var i = 0; i < this.backBoxs.length; i++) {
            if (i == 0) {
                this.backBoxs[i].x = initX;
            }
            else {
                this.backBoxs[i].x = this.backBoxs[i - 1].x + this.backBoxs[i].width + props_1.props.backmargin;
            }
            this.backBoxs[i].y = initY;
            this.addChild(this.backBoxs[i]);
        }
        this.addEventListener(engine.Event.ENTER_FRAME, this.frameMove, this);
    };
    BackBoxs.prototype.frameMove = function () {
        var _this = this;
        this.backBoxs.forEach(function (item) {
            item.x -= props_1.props.moveSpeed;
            if (item.x <= 0) {
                var lastitem = _this.backBoxs.shift();
                lastitem.x = _this.backBoxs[_this.backBoxs.length - 1].x + item.width + props_1.props.backmargin;
                _this.backBoxs.push(lastitem);
            }
        });
    };
    return BackBoxs;
}(engine.Container));
exports.BackBoxs = BackBoxs;
