"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var props_1 = require("../props");
var Zhuazi = (function (_super) {
    __extends(Zhuazi, _super);
    function Zhuazi() {
        var _this = _super.call(this) || this;
        _this.moveArr = [];
        _this.prizeBoxs = [];
        return _this;
    }
    Zhuazi.prototype.setup = function () {
        this.ganNode = new engine.Container();
        this.moveNode = new engine.Container();
        this.ganNode.x = 280;
        this.ganNode.y = 350;
        this.bashouGan = new engine.Sprite(utils_1.getTextureByName("把手杆子"));
        this.bashouGan.x = 60;
        this.bashouGan.y = 275;
        this.bashou = new engine.Sprite(utils_1.getTextureByName("把手"));
        this.bashou.x = 0;
        this.bashou.y = 263;
        this.ganzi = new engine.Sprite(utils_1.getTextureByName("伸缩杆"));
        this.ganzi.x = 97;
        this.ganzi.y = 290;
        this.connect = new engine.Sprite(utils_1.getTextureByName("连接点"));
        this.connect.x = 18;
        this.connect.y = -5;
        this.left_zhuazi = new engine.Sprite(utils_1.getTextureByName("左爪"));
        this.left_zhuazi.x = -15;
        this.left_zhuazi.y = 60;
        this.left_zhuazi.anchorX = this.left_zhuazi.width;
        this.left_zhuazi.anchorY = 0;
        this.right_zhuazi = new engine.Sprite(utils_1.getTextureByName("右爪"));
        this.right_zhuazi.x = 98;
        this.right_zhuazi.y = 60;
        this.ganNode.addChild(this.left_zhuazi);
        this.ganNode.addChild(this.right_zhuazi);
        this.ganNode.addChild(this.connect);
        this.ganNode.x = 30;
        this.zhuaziY = this.ganNode.y;
        this.moveNode.addChild(this.ganzi);
        this.moveNode.addChild(this.ganNode);
        this.moveNode.addChild(this.bashou);
        this.moveNode.x = 262;
        this.addChild(this.bashouGan);
        this.addChild(this.moveNode);
        this.createPrizeBox();
    };
    Zhuazi.prototype.createPrizeBox = function () {
        var _this = this;
        this.box1 = new engine.Sprite(utils_1.getTextureByName("中奖狗盒"));
        this.box1["npcType"] = "box1";
        this.box2 = new engine.Sprite(utils_1.getTextureByName("中奖猫盒"));
        this.box2["npcType"] = "box2";
        this.box3 = new engine.Sprite(utils_1.getTextureByName("中奖草泥马盒"));
        this.box3["npcType"] = "box3";
        this.box4 = new engine.Sprite(utils_1.getTextureByName("中奖狗盒"));
        this.box4["npcType"] = "box4";
        this.box5 = new engine.Sprite(utils_1.getTextureByName("中奖猫盒"));
        this.box5["npcType"] = "box5";
        this.prizeBoxs = [this.box1, this.box2, this.box3, this.box4, this.box5];
        this.prizeBoxs.forEach(function (item) {
            _this.ganNode.addChild(item);
            item.visible = false;
            item.x = 15;
            item.y = 48;
        });
    };
    Zhuazi.prototype.showPrizeBox = function () {
        var _this = this;
        this.prizeBoxs.forEach(function (item) {
            console.log(_this.GameView.getBox()['npcType']);
            if (item['npcType'] === _this.GameView.getBox()['npcType']) {
                item.visible = true;
                _this.itemShow = item;
            }
            else {
                item.visible = false;
            }
        });
    };
    Zhuazi.prototype.move = function () {
        var _this = this;
        var rndist = Math.random();
        var halfWidth = this.bashou.width / 2;
        var randomX = rndist * (rndist > 0.5 ? 1 : -1) * props_1.props.bashouMoveDist;
        console.log(randomX);
        engine.Tween.get(this.moveNode).to({ x: 370 + halfWidth - 71 }, 1000).call(function () {
            _this.zhangkai();
        });
    };
    Zhuazi.prototype.zhangkai = function () {
        var _this = this;
        this.left_zhuazi.anchorX = this.left_zhuazi.width;
        this.left_zhuazi.anchorY = 0;
        engine.Tween.get(this.left_zhuazi, { loop: false }).to({ rotation: props_1.props.leftRotation }, 1000);
        engine.Tween.get(this.right_zhuazi, { loop: false }).to({ rotation: props_1.props.rightRotation }, 1000);
        setTimeout(function () {
            _this.getLong();
        }, 500);
    };
    Zhuazi.prototype.getLong = function () {
        var _this = this;
        var droptime = Number((this.GameView.getMoveX() / 60 - 1).toFixed(2)) * 1000;
        console.log('dr', droptime);
        var times = (props_1.props.ganMoveEndY - this.ganzi.y) / this.ganzi.height;
        console.log(Number(times.toFixed(2)));
        engine.Tween.get(this.ganzi).to({ scaleY: Number(times.toFixed(2)) }, droptime).to({ scaleY: 1 }, droptime);
        console.log('node', this.zhuaziY);
        engine.Tween.get(this.ganNode).to({ y: props_1.props.ganMoveEndY }, droptime).call(function () {
            _this.GameView.stopMove();
            if (_this.GameView.ifPrize) {
                _this.showPrizeBox();
                _this.GameView.setVisible(false);
            }
        }).to({ y: this.zhuaziY }, droptime).call(function () {
            if (_this.GameView.ifPrize) {
                _this.itemShow.visible = false;
            }
            engine.globalEvent.dispatchEvent('doll-machine-gameover');
        });
    };
    Zhuazi.prototype.getReset = function () {
        this.left_zhuazi.anchorX = this.left_zhuazi.width;
        this.left_zhuazi.anchorY = 0;
        engine.Tween.get(this.moveNode, { loop: false }).to({ x: 262 }, 1000);
        engine.Tween.get(this.left_zhuazi, { loop: false }).to({ rotation: 0 }, 1000);
        engine.Tween.get(this.right_zhuazi, { loop: false }).to({ rotation: 0 }, 1000);
        this.GameView.resetMoveX();
    };
    return Zhuazi;
}(engine.Container));
exports.Zhuazi = Zhuazi;
