"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Wave = (function (_super) {
    __extends(Wave, _super);
    function Wave() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.duration = 1000;
        _this.waveMethod = 'rotate';
        _this.loop = -1;
        _this.autoPlay = true;
        _this._oldProps = {};
        return _this;
    }
    Wave.prototype.mounted = function () {
        this._startTime = 0;
        engine.copyProp(this._oldProps, this.host, oldPropFields);
        if (this.autoPlay) {
            this.play();
        }
    };
    Wave.prototype.update = function (t) {
        if (this._playing) {
            if (!this._startTime) {
                this._startTime = t;
            }
            var _a = this, duration = _a.duration, waveParams = _a.waveParams, _waveAlgorithm = _a._waveAlgorithm, host = _a.host, _oldProps = _a._oldProps;
            var pass = (t - this._startTime) % duration;
            var r = pass / duration * PI2;
            var loopCounting = Math.floor((t - this._startTime) / duration);
            if (loopCounting != this._loopCounting) {
                this._loopCounting = loopCounting;
                if (this.onLoopEnd()) {
                    r = PI2;
                }
            }
            var params = waveParams ? (waveParams.split(',')) : [];
            var props = _waveAlgorithm.apply(void 0, __spreadArrays(params, [r]));
            if (props.hasOwnProperty('x')) {
                host.x = (props.x || 0) + _oldProps.x;
            }
            if (props.hasOwnProperty('y')) {
                host.y = (props.y || 0) + _oldProps.y;
            }
            if (props.hasOwnProperty('sx')) {
                host.scaleX = props.sx;
            }
            if (props.hasOwnProperty('sy')) {
                host.scaleY = props.sy;
            }
            if (props.hasOwnProperty('r')) {
                host.rotation = props.r;
            }
        }
    };
    Wave.prototype.onLoopEnd = function () {
        if (this.loop < 0) {
        }
        else if (this._loopCounting < this.loop) {
        }
        else {
            this._playing = false;
            return true;
        }
    };
    Wave.prototype.play = function () {
        this._loopCounting = 0;
        this._playing = true;
        this._startTime = 0;
    };
    Wave.prototype.stop = function (revert) {
        if (revert === void 0) { revert = false; }
        this._playing = false;
        if (revert) {
            for (var key in this._oldProps) {
                var prop = this._oldProps[key];
                if (typeof prop === 'object') {
                    engine.injectProp(this.host[key], prop);
                }
                else {
                    this.host[key] = prop;
                }
            }
        }
    };
    Wave.prototype.onModify = function (value, key, oldValue) {
        switch (key) {
            case 'waveMethod':
                this._waveAlgorithm = waveLibs[this.waveMethod];
                break;
        }
    };
    Wave.id = 'wave';
    __decorate([
        engine.dirtyFieldTrigger
    ], Wave.prototype, "waveMethod", void 0);
    return Wave;
}(engine.ScriptBase));
exports.default = Wave;
var PI2 = Math.PI * 2;
var oldPropFields = {
    x: 'x',
    y: 'y',
    scaleX: 'scaleX',
    scaleY: 'scaleY',
    alpha: 'alpha',
    rotation: 'rotation',
};
var cos = Math.cos, sin = Math.sin, PI = Math.PI;
var waveLibs = {
    round: function (radius, t) {
        return { x: cos(t) * radius, y: sin(t) * radius };
    },
    cosWave: function (h, t) {
        return { x: cos(t) * h, y: 0 };
    },
    sinWave: function (h, t) {
        h = h || 1;
        return { x: 0, y: sin(t) * h };
    },
    rotate: function (t) {
        return { r: 360 * t / PI / 2 };
    },
    shake: function (angle, count, t) {
        return { r: sin(t * count) * angle };
    },
    breath: function (scale, t) {
        if (scale === void 0) { scale = 0.1; }
        return { sx: sin(t) * scale + 1, sy: -sin(t + PI / 4) * scale + 1 };
    },
    zoom: function (scale, t) {
        if (scale === void 0) { scale = 0.1; }
        return { sx: sin(t) * scale + 1, sy: sin(t) * scale + 1 };
    },
    fade: function (base, t) {
        if (base === void 0) { base = 1; }
        return { alpha: (sin(t) + 1) * 0.5 + base };
    },
};
