"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var TouchZoom = (function (_super) {
    __extends(TouchZoom, _super);
    function TouchZoom() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.zoomTo = 1.1;
        return _this;
    }
    TouchZoom.prototype.mounted = function () {
        this.host.anchorX = this.host.width / 2;
        this.host.anchorY = this.host.height / 2;
        this.host.addEventListener(engine.MouseEvent.MOUSE_DOWN, this._onMouseDown, this);
    };
    TouchZoom.prototype._onMouseDown = function (e) {
        this.host.scaleX = this.host.scaleY = this.zoomTo;
        this.host.stage.once(engine.MouseEvent.MOUSE_UP, this._onMouseUp, this);
    };
    TouchZoom.prototype._onMouseUp = function (e) {
        this.host.scaleX = this.host.scaleY = 1;
    };
    TouchZoom.id = 'touch-zoom';
    return TouchZoom;
}(engine.ScriptBase));
exports.default = TouchZoom;
