"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var BuriedPoint = (function (_super) {
    __extends(BuriedPoint, _super);
    function BuriedPoint() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.dpm = '0.0.0.0';
        _this.dcm = '0.0.0.0';
        _this.dom = '0.0.0.0';
        return _this;
    }
    BuriedPoint.prototype.mounted = function () {
        this.dpm && fill(this.dpm);
        this.dcm && fill(this.dcm);
        this.dom && fill(this.dom);
        this.host.addEventListener(engine.MouseEvent.CLICK, this._onClick, this);
    };
    BuriedPoint.prototype.awake = function () {
        log('exposure', this);
    };
    BuriedPoint.prototype._onClick = function (e) {
        log('click', this);
    };
    BuriedPoint.id = 'buried-point';
    return BuriedPoint;
}(engine.ScriptBase));
exports.default = BuriedPoint;
function fill(src) {
    var result = src;
    for (var key in engine.env) {
        result = result.replace(key, engine.env[key]);
    }
    return result;
}
function log(type, data) {
    var dpm = data.dpm, dcm = data.dcm, dom = data.dom;
    var params = {
        dpm: dpm, dcm: dcm, appID: engine.env.appID, projectID: engine.env.projectID
    };
    if (dom !== '0.0.0.0') {
        params.dom = dom;
    }
    var isExposure = type === 'exposure';
    engine.httpRequest(null, isExposure ? '//embedlog.duiba.com.cn/exposure/standard' : '/log/click', 'get', params, isExposure ? 'jsonp' : 'text');
}
