"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ZoomScroll = (function (_super) {
    __extends(ZoomScroll, _super);
    function ZoomScroll() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.autoInit = true;
        _this.duration = 1000;
        _this.index = 0;
        _this.itemWidth = 0;
        _this.itemHeight = 0;
        _this.scaleMin = 0.7;
        _this.scaleMax = 1;
        _this.alphaOut = 0.5;
        _this.alphaIn = 1;
        _this._startDragOffset = { x: 0, y: 0 };
        _this._dragOffset = { x: 0, y: 0 };
        return _this;
    }
    ZoomScroll.prototype.mounted = function () {
        this._centerOffset = this.host.width / 2;
        if (this.autoInit) {
            this.init();
        }
    };
    ZoomScroll.prototype.sleep = function () {
    };
    ZoomScroll.prototype.update = function (t) {
    };
    ZoomScroll.prototype.init = function () {
        for (var i = 0, li = this.host.children.length; i < li; i++) {
            var child = this.host.children[i];
            child.anchorX = child.width / 2;
            child.anchorY = child.height / 2;
            child.x = child.ix = i * this.itemWidth + this._centerOffset - this.itemWidth / 2;
        }
        this.scrollTo(0, false);
        this.host.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onDragStart, this);
    };
    ZoomScroll.prototype.updateOffset = function (offset) {
        this._dragOffset.x = this._startDragOffset.x + offset.x;
        for (var i = 0, li = this.host.children.length; i < li; i++) {
            var child = this.host.children[i];
            var x = child.x = child.ix + this._dragOffset.x;
            var s = 40 / Math.abs(x - this._centerOffset + this.itemWidth / 2);
            child.scaleX = child.scaleY = x === 0 ? 1 : Math.min(s + this.scaleMin, this.scaleMax);
            child.alpha = x === 0 ? 1 : Math.min(s + this.alphaOut, this.alphaIn);
        }
    };
    ZoomScroll.prototype.onDragStart = function (event) {
        this.host.stage.addEventListener(engine.MouseEvent.MOUSE_MOVE, this.onDraging, this);
        this.host.stage.addEventListener(engine.MouseEvent.MOUSE_UP, this.onDragEnd, this);
        this._startDragPos = {
            x: event.stageX,
            y: event.stageY,
        };
        this._startDragOffset.x = this._dragOffset.x;
        this._startDragOffset.y = this._dragOffset.y;
    };
    ZoomScroll.prototype.onDraging = function (event) {
        if (!this._startDragPos) {
            return;
        }
        var _a = this._startDragPos, x = _a.x, y = _a.y;
        var stageX = event.stageX, stageY = event.stageY;
        var offset = {
            x: stageX - x,
            y: stageY - y,
        };
        this.updateOffset(offset);
    };
    ZoomScroll.prototype.onDragEnd = function (event) {
        this.host.stage.removeEventListener(engine.MouseEvent.MOUSE_MOVE, this.onDraging, this);
        this.host.stage.removeEventListener(engine.MouseEvent.MOUSE_UP, this.onDragEnd, this);
        if (!this._startDragPos) {
            return;
        }
        this._startDragOffset.x = 0;
        this._startDragOffset.y = 0;
        var index = Math.round(this._dragOffset.x / this.itemWidth);
        index = -Math.min(0, Math.max(1 - this.host.children.length, index));
        this['_index'] = index;
        this.scrollTo(index);
        this._startDragPos = null;
    };
    Object.defineProperty(ZoomScroll.prototype, "t", {
        get: function () {
            return this._dragOffset.x;
        },
        set: function (v) {
            this.updateOffset({ x: v, y: 0 });
        },
        enumerable: true,
        configurable: true
    });
    ZoomScroll.prototype.scrollTo = function (index, animation) {
        if (animation === void 0) { animation = true; }
        var indexPos = -index * this.itemWidth;
        if (animation) {
            engine.Tween.get(this, null, null, true)
                .to({ t: indexPos }, 100, engine.Ease.cubicOut);
        }
        else {
            this.t = indexPos;
        }
    };
    ZoomScroll.prototype.onModify = function (value, key, oldValue) {
        var _this = this;
        switch (key) {
            case 'index':
                var index_1 = value;
                if (oldValue !== undefined) {
                    index_1 = Math.max(0, Math.min(this.host.children.length - 1, value));
                    this['_index'] = index_1;
                }
                setTimeout(function () {
                    _this.scrollTo(index_1, oldValue !== undefined);
                });
                break;
        }
    };
    ZoomScroll.id = 'zoom-scroll';
    __decorate([
        engine.dirtyFieldTrigger
    ], ZoomScroll.prototype, "index", void 0);
    __decorate([
        engine.dirtyFieldTrigger
    ], ZoomScroll.prototype, "itemWidth", void 0);
    __decorate([
        engine.dirtyFieldTrigger
    ], ZoomScroll.prototype, "itemHeight", void 0);
    __decorate([
        engine.dirtyFieldTrigger
    ], ZoomScroll.prototype, "scaleMin", void 0);
    __decorate([
        engine.dirtyFieldTrigger
    ], ZoomScroll.prototype, "scaleMax", void 0);
    __decorate([
        engine.dirtyFieldTrigger
    ], ZoomScroll.prototype, "alphaOut", void 0);
    __decorate([
        engine.dirtyFieldTrigger
    ], ZoomScroll.prototype, "alphaIn", void 0);
    return ZoomScroll;
}(engine.ScriptBase));
exports.default = ZoomScroll;
