"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("../utils");
var PlayerPart = (function (_super) {
    __extends(PlayerPart, _super);
    function PlayerPart(name) {
        var _this = _super.call(this) || this;
        _this.changeRes(name);
        return _this;
    }
    PlayerPart.prototype.changeRes = function (name) {
        this.name = name;
        this.texture = utils_1.getTextureByName('body_normal_' + name);
    };
    ;
    PlayerPart.prototype.setSkin = function (name) {
        this.texture = utils_1.getTextureByName('body_' + name + '_' + this.name);
    };
    PlayerPart.prototype.localUpdate = function (x, y, rotation, sleeping) {
        this.x = x;
        this.y = y;
        this.rotation = rotation;
    };
    Object.defineProperty(PlayerPart.prototype, "fSize", {
        get: function () {
            return { width: this.fWidth, height: this.fHeight };
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PlayerPart.prototype, "fWidth", {
        get: function () {
            return this.width / utils_1.getfactor();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PlayerPart.prototype, "fHeight", {
        get: function () {
            return this.height / utils_1.getfactor();
        },
        enumerable: true,
        configurable: true
    });
    PlayerPart.prototype.reset = function () {
    };
    return PlayerPart;
}(engine.Sprite));
exports.PlayerPart = PlayerPart;
