"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ScoreLabel = (function (_super) {
    __extends(ScoreLabel, _super);
    function ScoreLabel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ScoreLabel.prototype.updateScore = function (score, formatFun, animation) {
        if (formatFun === void 0) { formatFun = null; }
        if (animation === void 0) { animation = true; }
        this.formatFun = formatFun;
        this._value = score;
        if (animation) {
            engine.Tween.get(this, null, null, true)
                .to({ temp: score }, 300);
        }
        else {
            this.updateLocal(score);
        }
    };
    Object.defineProperty(ScoreLabel.prototype, "score", {
        get: function () {
            return this._value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ScoreLabel.prototype, "temp", {
        get: function () {
            return this._temp;
        },
        set: function (v) {
            this._temp = v;
            this.updateLocal(v);
        },
        enumerable: true,
        configurable: true
    });
    ScoreLabel.prototype.updateLocal = function (v) {
        this.text = this.formatFun && this.formatFun(v) || v;
    };
    return ScoreLabel;
}(engine.Label));
exports.ScoreLabel = ScoreLabel;
