"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var props_1 = require("../props");
var ScoreLabel_1 = require("./ScoreLabel");
var PlayGame = (function (_super) {
    __extends(PlayGame, _super);
    function PlayGame() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.addlabelScore = null;
        _this.formatScore = function (s) {
            var t = (Math.ceil(s * 10) / 10).toString();
            t += t.indexOf('.') < 0 ? '.0' : '';
            return t;
        };
        return _this;
    }
    Object.defineProperty(PlayGame, "instance", {
        get: function () {
            if (this._instance == undefined) {
                this._instance = new PlayGame();
            }
            return this._instance;
        },
        enumerable: true,
        configurable: true
    });
    PlayGame.prototype.start = function (revive) {
        if (revive === void 0) { revive = false; }
        if (!revive) {
            this.normalScore = 0;
            this.rewardScore = 0;
            this.lastDialogTs = 0;
            this.initTouch();
            this.initLabScore();
            this.initAddlabel();
            this.initDialog();
        }
        this.registerEvent();
    };
    PlayGame.prototype.registerEvent = function () {
        this.touchLayer.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
        this.touchLayer.addEventListener(engine.MouseEvent.MOUSE_UP, this.onMouseUp, this);
        this.GameView.addEventListener(engine.Event.COMPLETE, this.onGameComplete, this);
        this.GameView.addEventListener('scoreChange', this.onScoreChange, this);
    };
    PlayGame.prototype.initTouch = function () {
        this.touchLayer = new engine.Rect();
        this.addChild(this.touchLayer);
        this.touchLayer.width = utils_1.getStage().width;
        this.touchLayer.height = utils_1.getStage().height;
        this.touchLayer.x = 0;
        this.touchLayer.y = 0;
        this.touchLayer.alpha = 0;
    };
    PlayGame.prototype.removeListener = function () {
        this.touchLayer.removeEventListener(engine.MouseEvent.MOUSE_DOWN, this.onMouseDown, this);
        this.touchLayer.removeEventListener(engine.MouseEvent.MOUSE_UP, this.onMouseUp, this);
        this.GameView.removeEventListener(engine.Event.COMPLETE, this.onGameComplete, this);
        this.GameView.removeEventListener('scoreChange', this.onScoreChange, this);
    };
    PlayGame.prototype.initLabScore = function () {
        this.labScore = new ScoreLabel_1.ScoreLabel();
        this.labScore.visible = props_1.props.showScore;
        this.labScore.updateScore(0, this.formatScore, false);
        this.labScore.fillColor = 'yellow';
        this.labScore.size = 46;
        this.labScore.x = 610;
        engine.Tween.get(this.labScore, { loop: false })
            .set({ y: -100 })
            .wait(300)
            .to({ y: 40 }, 200, engine.Ease.backOut);
        this.addChild(this.labScore);
    };
    PlayGame.prototype.initAddlabel = function () {
        this.addlabelScore = new engine.Label();
        this.addlabelScore.fillColor = 'yellow';
        this.addlabelScore.size = 40;
        this.addlabelScore.text = '';
        this.addlabelScore.x = 378;
        this.addlabelScore.y = 582;
        this.addlabelScore.visible = false;
        this.addChild(this.addlabelScore);
    };
    PlayGame.prototype.initDialog = function () {
        this.dialog = new engine.Image();
        this.dialog.x = 390;
        this.dialog.y = 323;
        this.addChild(this.dialog);
    };
    PlayGame.prototype.onMouseDown = function () {
        this.GameView.down();
    };
    PlayGame.prototype.onMouseUp = function () {
        this.GameView.up();
    };
    PlayGame.prototype.onGameComplete = function () {
        console.log('死亡');
        this.removeListener();
        var score = this.getScore();
        engine.globalEvent.dispatchEvent('walking-cat-game-end', { score: score });
    };
    PlayGame.prototype.getScore = function (round) {
        if (round === void 0) { round = false; }
        var score = (this.normalScore + this.rewardScore) / 10;
        score *= (props_1.props.scoreTimes || 1);
        if (round) {
            return Math.round(score);
        }
        return score;
    };
    PlayGame.prototype.onScoreChange = function (event) {
        var _a = event.data, score = _a.score, passType = _a.passType, rewardScore = _a.rewardScore;
        var scoreAdd;
        if (rewardScore) {
            this.rewardScore += rewardScore;
            scoreAdd = rewardScore;
        }
        else {
            scoreAdd = score - this.normalScore;
            this.normalScore = score;
        }
        var curScore = this.getScore();
        this.labScore.updateScore(curScore, this.formatScore);
        if (passType > 0 && passType <= 4) {
            var now = Date.now();
            if (now - this.lastDialogTs > 15000) {
                this.play(1);
                this.lastDialogTs = now;
            }
        }
        else if (passType == 10) {
            this.play(0);
            this.lastDialogTs = Date.now();
            this.GameView.setWitchFace('happy');
        }
        if (scoreAdd > 0) {
            var labScoreAdd_1 = this.addlabelScore;
            labScoreAdd_1.visible = props_1.props.showScore;
            labScoreAdd_1.alpha = 0;
            labScoreAdd_1.verticalCenter = 0;
            labScoreAdd_1.text = '+' + (scoreAdd / 10 * (props_1.props.scoreTimes || 1));
            engine.Tween.get(labScoreAdd_1, null, null, true)
                .to({ verticalCenter: -50, alpha: 1, }, 200, engine.Ease.cubicIn)
                .wait(300)
                .to({ verticalCenter: -100, alpha: 0, }, 100, engine.Ease.cubicOut)
                .call(function () {
                labScoreAdd_1.visible = false;
            }, this);
        }
        engine.globalEvent.dispatchEvent('walking-cat-game-changScore', { score: curScore });
    };
    PlayGame.prototype.play = function (id) {
        var img = this.dialog;
        img.texture = utils_1.getTextureByName('dialog_' + id);
        img.scaleX = img.scaleY = 0;
        img.alpha = 1;
        img.visible = true;
        engine.Tween.get(img, null, null, true)
            .to({
            scaleX: 1, scaleY: 1
        }, 500, engine.Ease.backOut)
            .wait(500)
            .to({
            alpha: 0,
        }, 300)
            .call(function () {
            img.visible = false;
        });
    };
    PlayGame.prototype.revive = function () {
        this.GameView.reset(true);
        this.GameView.start(true);
    };
    return PlayGame;
}(engine.Container));
exports.PlayGame = PlayGame;
