"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var Block = (function (_super) {
    __extends(Block, _super);
    function Block() {
        var _this = _super.call(this) || this;
        _this.bmp = new engine.Sprite();
        _this.addChild(_this.bmp = new engine.Sprite());
        return _this;
    }
    Block.prototype.reset = function (_a) {
        var type = _a.type;
        this.type = type;
        var bmp = this.bmp;
        bmp.alpha = 1;
        bmp.texture = this.getBlock();
        var _b = Block.configs[type], width = _b.width, off = _b.off;
        bmp.x = -(off + width / 2);
        bmp.y = -(bmp.height / 2);
    };
    Block.prototype.getBlock = function () {
        return utils_1.getTextureByName('block_' + this.type);
    };
    Block.prototype.playEffect = function () {
    };
    Block.prototype.playFadeOut = function () {
        return this.getTweenPromise(engine.Tween.get(this.bmp)
            .to({ alpha: 0 }, 100)
            .to({ alpha: 1 }, 100)
            .to({ alpha: 0 }, 100));
    };
    Block.prototype.onEffectComplete = function (event) {
        this.effectResolve && this.effectResolve();
        this.effectResolve = null;
    };
    Block.prototype.getTweenPromise = function (tween) {
        return new Promise(function (resolve) {
            tween.call(resolve);
        });
    };
    Block.configs = [
        { ratio: 0.6, width: 15, off: 32, effect: '', effect_offset: { x: 0, y: 0 } },
        { ratio: 0.1, width: 10, off: 18, effect: '', effect_offset: { x: 0, y: 0 } },
        { ratio: 0.15, width: 30, off: 32, effect: '', effect_offset: { x: 0, y: 0 } },
        { ratio: 0.1, width: 86, off: 28, effect: '', effect_offset: { x: 0, y: 0 } },
        { ratio: 0.5, width: 70, off: 20, effect: '', effect_offset: { x: 0, y: -20 } },
        { ratio: 0, width: 0, off: 0, effect: '', effect_offset: { x: 0, y: 0 } },
        { ratio: 0, width: 0, off: 0, effect: '', effect_offset: { x: 0, y: 0 } },
        { ratio: 0, width: 0, off: 0, effect: '', effect_offset: { x: 0, y: 0 } },
        { ratio: 0, width: 0, off: 0, effect: '', effect_offset: { x: 0, y: 0 } },
        { ratio: 0, width: 0, off: 0, effect: '', effect_offset: { x: 0, y: 0 } },
        { ratio: 0, width: 123, off: 23, effect: '', effect_offset: { x: 0, y: 0 } },
    ];
    return Block;
}(engine.Container));
exports.Block = Block;
