"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var Game_1 = require("./Game/Game");
var MTimer_1 = require("./Global/MTimer");
var DebugMgr_1 = require("./Mgr/DebugMgr");
var GuideMgr_1 = require("./Mgr/GuideMgr");
var ShootPlanet = (function (_super) {
    __extends(ShootPlanet, _super);
    function ShootPlanet() {
        var _this = _super.call(this) || this;
        _this.game = null;
        _this.customProperty();
        _this.width = 750;
        _this.height = 1624;
        _this.init();
        engine.globalEvent.addEventListener('game-create', _this.onActive, _this);
        engine.globalEvent.addEventListener('game-destroy', _this.onSleep, _this);
        engine.globalEvent.addEventListener('game-revive', _this.onRevive, _this);
        engine.globalEvent.addEventListener('game-pause', _this.onPause, _this);
        engine.globalEvent.addEventListener('game-resume', _this.onResume, _this);
        return _this;
    }
    ShootPlanet.prototype.onActive = function () {
        if (!this.game) {
            this.game = new Game_1.default(this);
        }
        if (GuideMgr_1.default.instance.guideFlag == true) {
            var car = this.game._car;
            GuideMgr_1.default.instance.runGuide(0, car.x + car.width / 2, car.y + car.height / 2);
        }
        if (GuideMgr_1.default.instance.guideDone) {
            this.game.onGuideDone();
        }
    };
    ShootPlanet.prototype.onSleep = function () {
        this.game.destroy();
        this.game = null;
    };
    ShootPlanet.prototype.onRevive = function () {
        this.game.revive();
    };
    ShootPlanet.prototype.onPause = function () {
        this.game.pause = true;
    };
    ShootPlanet.prototype.onResume = function () {
        this.game.pause = false;
    };
    ShootPlanet.prototype.init = function () {
        MTimer_1.default.init();
        DebugMgr_1.default.instance.init(this);
    };
    ShootPlanet.prototype.customProperty = function () {
        Object.defineProperty(engine.Point.prototype, 'length', {
            get: function () {
                return Math.sqrt(this.x * this.x + this.y * this.y);
            }
        });
        engine.DisplayObject.prototype.destroy = function () {
            this.parent.removeChild(this);
        };
    };
    return ShootPlanet;
}(engine.Container));
exports.ShootPlanet = ShootPlanet;
