"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../../props");
var GuideMask_1 = require("../Game/GuideMask");
var DataMgr_1 = require("./DataMgr");
var MConfigs_1 = require("../Global/MConfigs");
var GuideMgr = (function () {
    function GuideMgr() {
        this.done = [];
        this.currentGuideMask = null;
    }
    Object.defineProperty(GuideMgr, "instance", {
        get: function () {
            if (!GuideMgr._instance) {
                GuideMgr._instance = new GuideMgr();
            }
            return GuideMgr._instance;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GuideMgr.prototype, "guideFlag", {
        get: function () {
            return localStorage.getItem("shoot-planet_" + props_1.props.guideFlagKey) != "false";
        },
        set: function (v) {
            localStorage.setItem("shoot-planet_" + props_1.props.guideFlagKey, v ? "true" : "false");
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GuideMgr.prototype, "container", {
        set: function (c) {
            this._container = c;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GuideMgr.prototype, "guideDone", {
        get: function () {
            return !this.guideFlag || this.done.length >= Object.keys(MConfigs_1.MConfigs.guide).length;
        },
        enumerable: true,
        configurable: true
    });
    GuideMgr.prototype.runGuide = function (index, x, y, end) {
        var _this = this;
        if (end === void 0) { end = false; }
        if (this.done[index] || this.guideFlag == false)
            return;
        this.done.push(index);
        DataMgr_1.DataMgr.game.pause = true;
        this.currentGuideMask = new GuideMask_1.default(index, x, y);
        this.currentGuideMask.onClick = function (context) {
            context.destroy();
            DataMgr_1.DataMgr.game.pause = false;
            if (_this.done.length >= Object.keys(MConfigs_1.MConfigs.guide).length) {
                DataMgr_1.DataMgr.game.onGuideDone();
            }
            if (end) {
                _this.guideFlag = false;
            }
        };
        this._container.addChild(this.currentGuideMask);
    };
    GuideMgr._instance = null;
    return GuideMgr;
}());
exports.default = GuideMgr;
