"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var utils_1 = require("./utils");
var GameView = (function (_super) {
    __extends(GameView, _super);
    function GameView() {
        var _this = _super.call(this) || this;
        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
        return _this;
    }
    GameView.prototype.setup = function () {
        if (this._hasSetup) {
            return;
        }
        this._hasSetup = true;
        this.NpcBg = new engine.Container();
        this.NpcBg.x = props_1.props.initX;
        this.NpcBg.y = props_1.props.initY;
        this.addChild(this.NpcBg);
        this.bottomCircle = new engine.Sprite(utils_1.getTextureByName('底座'));
        this.bottomCircle.x = 17;
        this.bottomCircle.y = 305;
        this.loveDot = new engine.Sprite(utils_1.getTextureByName('点缀'));
        this.loveDot.x = 0;
        this.loveDot.y = 6;
        this.giftboxSvga = utils_1.createSvga('初始礼盒');
        this.giftboxSvga.x = 105;
        this.giftboxSvga.y = 37;
        this.giftAfterSvga = utils_1.createSvga("拆礼盒");
        this.giftAfterSvga.x = 105;
        this.giftAfterSvga.y = 0;
        this.giftAfterSvga.visible = false;
        this.NpcBg.addChild(this.bottomCircle);
        this.NpcBg.addChild(this.giftboxSvga);
        this.NpcBg.addChild(this.giftAfterSvga);
        this.NpcBg.addChild(this.loveDot);
        this.giftboxSvga.play(false, true);
    };
    GameView.prototype.reset = function () {
        this.giftboxSvga.visible = true;
        this.giftAfterSvga.visible = false;
    };
    GameView.prototype.start = function () {
        this.giftAfterSvga.visible = true;
        this.giftboxSvga.visible = false;
        this.giftAfterSvga.play(false, false);
        this.giftAfterSvga.once(engine.Event.END_FRAME, function () {
            engine.globalEvent.dispatchEvent('open-gift-game-end');
        }, this);
    };
    GameView.prototype.resume = function () {
        this.reset();
        this.start();
    };
    return GameView;
}(engine.Container));
exports.default = GameView;
