"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GameView_1 = require("./GameView");
var props_1 = require("../props");
var LispstickTurntable = (function (_super) {
    __extends(LispstickTurntable, _super);
    function LispstickTurntable() {
        var _this = _super.call(this) || this;
        engine.globalEvent.addEventListener('jump-high-reset', _this.reset, _this);
        engine.globalEvent.addEventListener('jump-high-start', _this.start, _this);
        engine.globalEvent.addEventListener('jump-high-pause', _this.pause, _this);
        engine.globalEvent.addEventListener('jump-high-resume', _this.resume, _this);
        engine.globalEvent.addEventListener('jump-high-revive', _this.revive, _this);
        _this.addEventListener(engine.MouseEvent.CLICK, _this.onTap, _this);
        var gameView = _this._gameView = new GameView_1.default();
        _this.addChild(gameView);
        return _this;
    }
    LispstickTurntable.prototype.reset = function () {
        this._gameView.reset();
    };
    LispstickTurntable.prototype.start = function (event) {
        if ('jump-high-start') {
            props_1.injectProps(event.data);
        }
        this._status = 1;
        this._gameView.start();
    };
    LispstickTurntable.prototype.pause = function () {
        this._gameView.pause();
    };
    LispstickTurntable.prototype.resume = function () {
        this._gameView.resume();
    };
    LispstickTurntable.prototype.revive = function () {
        this._gameView.revive();
    };
    LispstickTurntable.prototype.onTap = function (event) {
        this._gameView.jump();
    };
    return LispstickTurntable;
}(engine.Container));
exports.LispstickTurntable = LispstickTurntable;
