"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GameView_1 = require("./GameView");
var props_1 = require("../props");
var LipstickTurntable = (function (_super) {
    __extends(LipstickTurntable, _super);
    function LipstickTurntable() {
        var _this = _super.call(this) || this;
        engine.globalEvent.addEventListener('lipstick-turntable-reset', _this.reset, _this);
        engine.globalEvent.addEventListener('lipstick-turntable-start', _this.start, _this);
        engine.globalEvent.addEventListener('lipstick-turntable-pause', _this.pause, _this);
        engine.globalEvent.addEventListener('lipstick-turntable-resume', _this.resume, _this);
        engine.globalEvent.addEventListener('lipstick-turntable-revive', _this.revive, _this);
        _this.addEventListener(engine.MouseEvent.CLICK, _this.onTap, _this);
        var gameView = _this._gameView = new GameView_1.default();
        _this.addChild(gameView);
        return _this;
    }
    LipstickTurntable.prototype.reset = function () {
        this._gameView.reset();
    };
    LipstickTurntable.prototype.start = function (event) {
        if ('lipstick-turntable-start') {
            props_1.injectProps(event.data);
        }
        this._status = 1;
        this._gameView.start();
    };
    LipstickTurntable.prototype.pause = function () {
        this._gameView.pause();
    };
    LipstickTurntable.prototype.resume = function () {
        this._gameView.resume();
    };
    LipstickTurntable.prototype.revive = function () {
        this._gameView.revive();
    };
    LipstickTurntable.prototype.onTap = function (event) {
        this._gameView.jump();
    };
    return LipstickTurntable;
}(engine.Container));
exports.LipstickTurntable = LipstickTurntable;
