"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var utils_1 = require("./utils");
var GuideLayer = (function (_super) {
    __extends(GuideLayer, _super);
    function GuideLayer() {
        var _this = _super.call(this) || this;
        _this.setup();
        return _this;
    }
    GuideLayer.prototype.setup = function () {
    };
    GuideLayer.prototype.show = function (id, options) {
        var _this = this;
        return new Promise(function (resolve) {
            _this.visible = true;
            if (!_this.guideMask) {
                var _a = _this.stage, width = _a.width, height = _a.height;
                var guideMask = _this.guideMask = new engine.Container();
                var guideHole = new engine.Image(utils_1.getTextureByName('引导遮罩'));
                guideHole.x = (width - guideHole.width) / 2;
                guideHole.y = options.y;
                guideMask.addChild(guideHole);
                _this.createRect(guideMask, 0, 0, width, guideHole.y);
                _this.createRect(guideMask, 0, guideHole.y, guideHole.x, guideHole.height);
                _this.createRect(guideMask, guideHole.x + guideHole.width, guideHole.y, width - guideHole.x - guideHole.width, guideHole.height);
                _this.createRect(guideMask, 0, guideHole.y + guideHole.height, width, height - guideHole.y - guideHole.height);
                var label = _this.label = new engine.Label();
                label.fillColor = 'white';
                label.size = 25;
                label.text = props_1.props.guideText;
                label.x = (width - label.width) / 2;
                label.y = guideHole.y + guideHole.height + 50;
                guideMask.addChild(label);
                _this.addChild(guideMask);
            }
            _this.once(engine.MouseEvent.CLICK, function () {
                this.visible = false;
                resolve();
            }, _this);
        });
    };
    GuideLayer.prototype.createRect = function (container, x, y, width, height) {
        var rect = new engine.Rect();
        rect.x = x;
        rect.y = y;
        rect.width = width;
        rect.height = height;
        rect.fillColor = 'black';
        rect.alpha = 0.7;
        container.addChild(rect);
    };
    return GuideLayer;
}(engine.Container));
exports.GuideLayer = GuideLayer;
