"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var Background = (function (_super) {
    __extends(Background, _super);
    function Background() {
        return _super.call(this) || this;
    }
    Background.prototype.setup = function () {
        var _a = this.stage, width = _a.width, height = _a.height;
        var bg = this._bg = new engine.Image(utils_1.getTextureByName('背景图'));
        bg.anchorX = bg.width / 2;
        bg.anchorY = bg.height / 2;
        bg.x = -(bg.width - width) / 2;
        bg.y = -(bg.height - height) / 2;
        this.addChild(bg);
        this._minScale = width / bg.width;
    };
    Background.prototype.playZoom = function (type, duration) {
        var _this = this;
        if (duration === void 0) { duration = 700; }
        return new Promise(function (resolve) {
            var scale = type === 'in' ? 1 : _this._minScale;
            engine.Tween.get(_this._bg, null, null, true)
                .to({ scaleX: scale, scaleY: scale }, duration, engine.Ease.cubicInOut)
                .call(resolve);
        });
    };
    return Background;
}(engine.Container));
exports.Background = Background;
