"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
function getTexture(uuid) {
    return engine.Texture.from(uuid);
}
exports.getTexture = getTexture;
function getTextureByName(name) {
    return getTexture(getAssetByName(name).uuid);
}
exports.getTextureByName = getTextureByName;
function getBlockAsset(type) {
    return engine.getAssetByName(props_1.props.blockAssets[type]);
}
exports.getBlockAsset = getBlockAsset;
function createSvga(name, anchorName) {
    var inst = new svga.Svga();
    inst.source = 'asset://' + getAssetByName(name).uuid;
    var anchor = props_1.props[anchorName];
    if (anchor) {
        inst.x = -anchor.x;
        inst.y = -anchor.y;
        inst.anchorX = anchor.x;
        inst.anchorY = anchor.y;
    }
    return inst;
}
exports.createSvga = createSvga;
function playSound(name) {
    engine.playSound(getAssetByName(name).uuid, { keep: true });
}
exports.playSound = playSound;
