"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GameView_1 = require("./GameView");
var props_1 = require("../props");
var JumpHigh = (function (_super) {
    __extends(JumpHigh, _super);
    function JumpHigh() {
        var _this = _super.call(this) || this;
        engine.globalEvent.addEventListener('jump-high-reset', _this.reset, _this);
        engine.globalEvent.addEventListener('jump-high-start', _this.start, _this);
        engine.globalEvent.addEventListener('jump-high-pause', _this.pause, _this);
        engine.globalEvent.addEventListener('jump-high-resume', _this.resume, _this);
        engine.globalEvent.addEventListener('jump-high-revive', _this.revive, _this);
        _this.addEventListener(engine.MouseEvent.MOUSE_DOWN, _this.onTap, _this);
        var gameView = _this._gameView = new GameView_1.default();
        _this.addChild(gameView);
        return _this;
    }
    JumpHigh.prototype.reset = function () {
        this._gameView.reset();
    };
    JumpHigh.prototype.start = function (event) {
        if ('jump-high-start') {
            props_1.injectProps(event.data);
        }
        this._status = 1;
        this._gameView.start();
    };
    JumpHigh.prototype.pause = function () {
        this._gameView.pause();
    };
    JumpHigh.prototype.resume = function () {
        this._gameView.resume();
    };
    JumpHigh.prototype.revive = function () {
        this._gameView.revive();
    };
    JumpHigh.prototype.onTap = function (event) {
        this._gameView.jump();
    };
    return JumpHigh;
}(engine.Container));
exports.JumpHigh = JumpHigh;
