"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var props_1 = require("../props");
var Goods = (function (_super) {
    __extends(Goods, _super);
    function Goods() {
        var _this = _super.call(this) || this;
        var body;
        body = _this._body = new engine.Rect();
        var rain = new engine.Sprite(utils_1.getTextureByName('雨滴'));
        rain["npcType"] = "rain";
        var stone = new engine.Sprite(utils_1.getTextureByName('石块'));
        stone["npcType"] = "stone";
        var boom = new engine.Sprite(utils_1.getTextureByName('炸弹'));
        boom["npcType"] = "boom";
        rain.visible = false;
        stone.visible = false;
        boom.visible = false;
        body.addChild(rain);
        body.addChild(stone);
        body.addChild(boom);
        _this.addChild(body);
        body.width = .0001;
        body.height = .0001;
        body.mouseEnabled = false;
        return _this;
    }
    Goods.prototype.getRandomNumberByRange = function (start, end) {
        return Math.floor(Math.random() * (end - start) + start);
    };
    Goods.prototype.reset = function () {
        this.visible = true;
        this.rotation = 0;
        this.anchorOffsetY = 0;
        this.y = 0;
        this.x = (750 - 120) * Math.random() + 30;
        this.rotation = 0;
        var random = Math.random();
        if (random < props_1.props.goodsProbability[0]) {
            this.showNpc("rain");
        }
        else if (random >= props_1.props.goodsProbability[0] && random <= (props_1.props.goodsProbability[0] + props_1.props.goodsProbability[1])) {
            this.showNpc("stone");
        }
        else if (random > (props_1.props.goodsProbability[0] + props_1.props.goodsProbability[1])) {
            this.showNpc("boom");
        }
    };
    Goods.prototype.showNpc = function (type) {
        for (var i = 0; i < this._body.children.length; i++) {
            this._body.children[i].visible = false;
            this._body.children[i].mouseEnabled = false;
        }
        for (var i = 0; i < this._body.children.length; i++) {
            if (this._body.children[i]["npcType"] == type) {
                this["npcType"] = type;
                this._body.children[i].visible = true;
                this._body.children[i].mouseEnabled = false;
            }
        }
    };
    Object.defineProperty(Goods.prototype, "anchorOffsetY", {
        set: function (v) {
            this._body.y = v;
        },
        enumerable: true,
        configurable: true
    });
    return Goods;
}(engine.Container));
exports.Goods = Goods;
