"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var GameView_1 = require("./GameView");
var props_1 = require("../props");
var GameWrapper = (function (_super) {
    __extends(GameWrapper, _super);
    function GameWrapper() {
        var _this = _super.call(this) || this;
        engine.globalEvent.addEventListener('food-fell-reset', _this.reset, _this);
        engine.globalEvent.addEventListener('food-fell-start', _this.start, _this);
        engine.globalEvent.addEventListener('food-fell-pause', _this.pause, _this);
        engine.globalEvent.addEventListener('food-fell-resume', _this.resume, _this);
        engine.globalEvent.addEventListener('food-fell-revive', _this.revive, _this);
        engine.globalEvent.addEventListener('food-fell-clear', _this.clear, _this);
        _this.addEventListener(engine.MouseEvent.CLICK, _this.onTap, _this);
        var gameView = _this._gameView = new GameView_1.default();
        _this.addChild(gameView);
        return _this;
    }
    GameWrapper.prototype.reset = function (event) {
        props_1.injectProps(event.data);
        this._gameView.visible = true;
        this._gameView.reset();
    };
    GameWrapper.prototype.start = function (event) {
        props_1.injectProps(event.data);
        this._status = 1;
        this._gameView.start();
    };
    GameWrapper.prototype.pause = function () {
        this._gameView.pause();
    };
    GameWrapper.prototype.resume = function () {
        this._gameView.resume();
    };
    GameWrapper.prototype.revive = function () {
        this._gameView.revive();
    };
    GameWrapper.prototype.clear = function () {
        this._gameView.visible = false;
    };
    GameWrapper.prototype.onTap = function (event) {
    };
    return GameWrapper;
}(engine.Container));
exports.GameWrapper = GameWrapper;
