"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ScoreLabel = (function (_super) {
    __extends(ScoreLabel, _super);
    function ScoreLabel() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ScoreLabel.prototype.updateScore = function (score, animation) {
        if (animation === void 0) { animation = true; }
        this._value = score;
        if (animation && this._tmp) {
            this.animationUpdate();
        }
        else {
            this.updateLocal(score);
        }
    };
    ScoreLabel.prototype.animationUpdate = function () {
        var _this = this;
        var tmpInterval = setInterval(function () {
            _this._tmp += 1;
            if (_this._tmp <= _this._value) {
                _this.text = _this._tmp;
            }
            else {
                _this._tmp = _this._value;
                clearInterval(tmpInterval);
            }
        }, 50);
    };
    ScoreLabel.prototype.updateLocal = function (v) {
        this._tmp = v;
        this.text = v;
    };
    return ScoreLabel;
}(engine.Label));
exports.ScoreLabel = ScoreLabel;
