"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var props_1 = require("../props");
var utils_1 = require("./utils");
var Player = (function (_super) {
    __extends(Player, _super);
    function Player() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Player.prototype.initPlayer = function (pierWidth) {
        this._container = new engine.Container();
        this.addChild(this._container);
        this.playerNode = utils_1.createSvga('walk');
        this._container.addChild(this.playerNode);
        this.playerNode.y = 675;
        this.playerNode.x = pierWidth / 2 - 80;
        this.playerNode.play();
    };
    Player.prototype.setViewport = function (pos, callBack, pierWidth) {
        var tmpPos = 0;
        var isSuccess = false;
        if (!pierWidth) {
            tmpPos = pos;
            isSuccess = true;
        }
        else {
            tmpPos = pierWidth - this.playerNode.x + pos - 60;
        }
        this.playGoTween(tmpPos, callBack, isSuccess);
    };
    Player.prototype.playGoTween = function (pos, callBack, isSuccess) {
        var _this = this;
        engine.Tween.get(this._container, { loop: false })
            .to({ x: pos }, props_1.props.playerMoveSpeed)
            .call(function () {
            engine.Tween.removeTweens(_this._container);
            if (isSuccess) {
                if (callBack) {
                    callBack();
                }
            }
            else {
                _this.playDropTween(callBack);
            }
        });
    };
    Player.prototype.playDropTween = function (callBack) {
        var _this = this;
        engine.Tween.get(this._container, { loop: false })
            .to({ y: 2000 }, 1000)
            .call(function () {
            engine.Tween.removeTweens(_this._container);
            if (callBack) {
                callBack();
            }
        });
    };
    Player.prototype.setBackViewport = function (callBack) {
        var _this = this;
        engine.Tween.get(this._container, { loop: false })
            .to({ x: 0 }, props_1.props.pierMoveTime)
            .call(function () {
            engine.Tween.removeTweens(_this._container);
            if (callBack) {
                callBack();
            }
        });
    };
    return Player;
}(engine.Container));
exports.Player = Player;
