"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var utils_1 = require("./utils");
var Goods = (function (_super) {
    __extends(Goods, _super);
    function Goods() {
        var _this = _super.call(this) || this;
        var body;
        body = _this._body = new engine.Rect();
        var box1 = new engine.Sprite(utils_1.getTextureByName("草泥马盒"));
        box1["npcType"] = "box1";
        var box2 = new engine.Sprite(utils_1.getTextureByName("狗盒"));
        box2["npcType"] = "box2";
        var box3 = new engine.Sprite(utils_1.getTextureByName("猫盒"));
        box3["npcType"] = "box3";
        box1.visible = false;
        box2.visible = false;
        box3.visible = false;
        body.addChild(box1);
        body.addChild(box2);
        body.addChild(box3);
        _this.addChild(body);
        body.width = 0.0001;
        body.height = 0.0001;
        body.mouseEnabled = false;
        return _this;
    }
    Goods.prototype.getRandomNumberByRange = function (start, end) {
        return Math.floor(Math.random() * (end - start) + start);
    };
    Goods.prototype.reset = function () {
        this.visible = true;
        this.y = 200;
        this.x = 0;
        this.rotation = 0;
        var random = Math.random();
        if (random < 0.3) {
            this.showNpc("box1");
        }
        else if (random < 0.6) {
            this.showNpc("box2");
        }
        else {
            this.showNpc("box3");
        }
    };
    Goods.prototype.showNpc = function (type) {
        for (var i = 0; i < this._body.children.length; i++) {
            this._body.children[i].visible = false;
            this._body.children[i].mouseEnabled = false;
        }
        for (var i = 0; i < this._body.children.length; i++) {
            if (this._body.children[i]["npcType"] == type) {
                this["npcType"] = type;
                console.log(type);
                this._body.children[i].visible = true;
                this._body.children[i].mouseEnabled = false;
            }
        }
    };
    Object.defineProperty(Goods.prototype, "anchorOffsetY", {
        set: function (v) {
            this._body.y = v;
        },
        enumerable: true,
        configurable: true
    });
    return Goods;
}(engine.Container));
exports.Goods = Goods;
