/**
 * Created by rockyl on 2019-12-16.
 */

(async function () {
	const customId = engine.queryParams.id;
	console.log(customId);

	let customModule = await fetch(`../dist/customs/${customId}.json`);
	customModule = await customModule.json();
	console.log(customModule);

	launchWithCustomModule(customModule);
})();

function launchWithCustomModule(customModule) {
	engine.globalEvent.addEventListener('update-game-status', (e) => {
		console.log(e.type, e.data);
	});

	engine.registerCustomCodeModule(customModule);
	engine.launchWithConfig({
		options: {
			entrySceneView: 'entry',
		},
		assets: [],
		customs: [customModule],
		views: [{
			name: 'entry',
			type: 'node',
		}],
	}, null, function () {
		engine.addCustomModule(customModule.id, engine.gameStage.sceneContainer.getChildAt(0));

		setTimeout(() => {
			engine.globalEvent.dispatchEvent('start-game', {level: 1});
		}, 500);
	});
}
