/**
 * Created by rockyl on 2019-11-20.
 */

export default class TouchZoom extends engine.ScriptBase{
	static id = 'touch-zoom';

	zoomTo = 1.1;

	mounted() {
		this.host.anchorX = this.host.width / 2;
		this.host.anchorY = this.host.height / 2;

		this.host.addEventListener(engine.MouseEvent.MOUSE_DOWN, this._onMouseDown, this);
	}

	private _onMouseDown(e) {
		this.host.scaleX = this.host.scaleY = this.zoomTo;
		this.host.stage.once(engine.MouseEvent.MOUSE_UP, this._onMouseUp, this);
	}

	private _onMouseUp(e) {
		this.host.scaleX = this.host.scaleY = 1;
	}
}
