/**
 * Created by rockyl on 2019-11-20.
 *
 * 延时防连点
 */

export default class DelayInvokeTouch extends engine.ScriptBase {
	static id = 'delay-invoke-touch';

	@engine.dirtyFieldTrigger
	delay: number = 2000;

	mounted() {
		this.host.addEventListener(engine.MouseEvent.CLICK, this._onClick, this);
	}

	private _onClick(event: engine.MouseEvent) {
		this.host.mouseEnabled = this.host.mouseChildren = false;

		setTimeout(this.onTimeout, this.delay);
	}

	private onTimeout = () => {
		this.host.mouseEnabled = this.host.mouseChildren = true;
	}
}
