/**
 * Created by rockyl on 2019-11-16.
 */

let effect = engine.findVariable('effect', args, props);
let effectParams = engine.findVariable('effectParams', args, props);
let showLoading = engine.findVariable('showLoading', args, props);

if(showLoading !== undefined){
	showLoading = false;
}

if (!props.viewName) {
	console.log('没有设置视图名');
	next('exception', '没有设置视图名');
} else {
	let gameStage = engine.gameStage;
	gameStage.instantiateView(props.viewName, true, showLoading).then(
		view => {
			if (view) {
				let options = {
					effect,
					effectParams,
					center: props.center,
					modalAlpha: props.modalAlpha,
				};
				gameStage.popupContainer.push(view, options);
			}
		}
	);

	next('complete');
}
