/**
 * Created by rockyl on 2019-11-16.
 */

let effect = engine.findVariable('effect', args, props);
let effectParams = engine.findVariable('effectParams', args, props);

let options = {
	effect,
	effectParams,
};

if (props.popAll) {
	if (!props.viewName) {
		console.log('没有设置视图名');
		next('exception', '没有设置视图名');
	} else {
		let gameStage = engine.gameStage;
		gameStage.instantiateView(props.viewName).then(
			view => {
				if (view) {
					gameStage.sceneContainer.popAll(view, options);
					next('complete');
				} else {
					next('exception', '视图不存在');
				}
			});
	}
} else {
	engine.gameStage.sceneContainer.pop(options);

	next('complete');

}
