/**
 * Created by rockyl on 2019-12-05.
 */

declare const wx:any;

if(args.env !== 'weixin'){
	next('pass');
}else{
	const {title, content, url, thumbnail} = args;

	let params = {
		title: title,
		desc: content,
		link: url,
		imgUrl: thumbnail,
		success: function () {
			engine.globalEvent.dispatchEvent('share-success');
		},
		cancel: function () {
			engine.globalEvent.dispatchEvent('share-cancel');
		}
	};

	const wxEvents = ['onMenuShareTimeline', 'onMenuShareAppMessage', 'onMenuShareQQ', 'onMenuShareWeibo', 'onMenuShareQZone'];

	console.log('wx.ready start', JSON.stringify(params));
	wx.ready(() => {
		console.log('wx.ready');
		wxEvents.forEach(method => {
			wx[method](params);
		});
	});

	if(props.update){
		next('success');
	}else{
		next('guide');
	}
}

