/**
 * Created by rockyl on 2019-11-16.
 */

let leftValue = engine.findVariable('left', args, props);
let rightValue = engine.findVariable('right', args, props);
let operator = engine.findVariable('operator', args, props);

let result;

if (operator === 'exist') {
	result = !!leftValue;
} else {
	switch (props.type) {
		case 'string':
			leftValue = '"' + leftValue + '"';
			rightValue = '"' + rightValue + '"';
			break;
		case 'number':
			leftValue = typeof leftValue === 'number' ? leftValue : parseFloat(leftValue);
			rightValue = typeof rightValue === 'number' ? rightValue : parseFloat(rightValue);
			break;
		case 'boolean':
			leftValue = typeof leftValue === 'boolean' ? leftValue :
				(leftValue === 'true' ? true :
					(leftValue === 'false' ? false : !!leftValue));
			rightValue = typeof rightValue === 'boolean' ? rightValue :
				(rightValue === 'true' ? true :
					(rightValue === 'false' ? false : !!rightValue));
			break;
	}

	let func = new Function('return ' + leftValue + operator + rightValue);

	result = func();
}

next(result ? 'true' : 'false');
