/**
 * 头部
 */
import {getTextureByName} from "../utils";
const factor = 10;

export class Head extends engine.Container implements IPlayerPart{
	imgFace:engine.Sprite;
	_headType;
	constructor(){
        super();
        this.imgFace = new engine.Sprite(getTextureByName('head_0'));
        this.addChild(this.imgFace);
        this.imgFace.anchorTexture.set(107/this.imgFace.width,155/this.imgFace.height);
		this.imgFace.y = 65;
		this._headType = '';
	}

	localUpdate(x, y, rotation, sleeping){
		this.x = x;
		this.y = y;
		this.rotation = rotation;
		//this.alpha = sleeping ? 0.8 : 1;
	}

	get fWidth(){               
		return this.width / factor;
	}
               
	get fHeight(){
		return this.height / factor;
	}

	switchFace(type, playAni){
		if(type == this._headType){
			return;
		}
        let headName = ''
        if(type == 'normal'){
			headName = 'head_0';
        }else if(type == 'happy'){
            headName = 'head_1'
        }else if(type == 1 || type == 0 || type == 2){
            headName = 'head_2';
        }else if(type == 3){
            headName = 'head_3';
        }else if(type == 4){
            headName = 'head_4';
		}
		this._headType = type;
        this.imgFace.texture = getTextureByName(headName);
        
		// this.currentState = 'face_' + type;
		// const ani: egret.tween.TweenGroup = this['ani_face_' + type];
		// if(playAni && ani){
		// 	ani.play(0);
		// }
	}
}
