/**
 * Created by rockyl on 2018/9/10.
 *
 * 分数标签
 */

export class ScoreLabel extends engine.Label {
	formatFun: Function;

	_value;
	_temp;

	updateScore(score, formatFun = null, animation = true) {
		this.formatFun = formatFun;
        this._value = score;

		if (animation) {
			engine.Tween.get(this, null, null, true)
				.to({temp: score}, 300);
		} else {
			this.updateLocal(score);
		}
	}

	get score() {
		return this._value;
	}

	private get temp() {
		return this._temp;
	}

	private set temp(v) {
		this._temp = v;
        this.updateLocal(v);
	}

	updateLocal(v) {
		this.text = this.formatFun && this.formatFun(v) || v;
	}
}
