

import GameView from "./GameView";
import { getStage ,getTextureByName} from "./utils";
import { props } from "../props";
import { ScoreLabel } from "./ScoreLabel";

export class PlayGame extends engine.Container{
    touchLayer: engine.Rect;
    public GameView:GameView;
    private addlabelScore: engine.Label = null;
    public labScore: ScoreLabel;
    private dialog:engine.Image;
    normalScore;
	rewardScore;
    lastDialogTs;
    private static _instance: PlayGame;
	public static get instance(): PlayGame {
		if (this._instance == undefined) {
			this._instance = new PlayGame();
		}
		return this._instance;
	}


    public start(revive = false) {
        if(!revive){
            this.normalScore = 0;
            this.rewardScore = 0;
            this.lastDialogTs = 0;
            this.initTouch();
          
            this.initLabScore();

            this.initAddlabel();
            this.initDialog();
        }
        this.registerEvent();
    }
    registerEvent(){
        this.touchLayer.addEventListener(engine.MouseEvent.MOUSE_DOWN,this.onMouseDown,this);
        this.touchLayer.addEventListener(engine.MouseEvent.MOUSE_UP,this.onMouseUp,this);
        this.GameView.addEventListener(engine.Event.COMPLETE, this.onGameComplete, this);
        this.GameView.addEventListener('scoreChange', this.onScoreChange, this);
    }
    initTouch(){
        this.touchLayer = new engine.Rect();
        this.addChild(this.touchLayer);
        this.touchLayer.width = getStage().width;
        this.touchLayer.height = getStage().height;
        this.touchLayer.x = 0;
        this.touchLayer.y = 0;
        this.touchLayer.alpha = 0;
    }
    removeListener(){
        this.touchLayer.removeEventListener(engine.MouseEvent.MOUSE_DOWN,this.onMouseDown,this);
        this.touchLayer.removeEventListener(engine.MouseEvent.MOUSE_UP,this.onMouseUp,this);
        this.GameView.removeEventListener(engine.Event.COMPLETE, this.onGameComplete, this);
        this.GameView.removeEventListener('scoreChange', this.onScoreChange, this);
    }
    initLabScore(){
        this.labScore = new ScoreLabel();
        this.labScore.visible = props.showScore;
        this.labScore.updateScore(0, this.formatScore, false);
        this.labScore.fillColor = 'yellow';
        this.labScore.size = 46;
        this.labScore.x = 610;
        engine.Tween.get(this.labScore,{loop:false})
        .set({y:-100})
        .wait(300)
        .to({y:40},200,engine.Ease.backOut)
        this.addChild(this.labScore);
    }
    initAddlabel(){
        this.addlabelScore = new engine.Label();
        this.addlabelScore.fillColor = 'yellow';
        this.addlabelScore.size = 40;
        this.addlabelScore.text = '';
        this.addlabelScore.x = 378;
        this.addlabelScore.y = 582;
        this.addlabelScore.visible = false;
        this.addChild(this.addlabelScore);
    }
    initDialog(){
        this.dialog = new engine.Image();
        this.dialog.x = 390;
        this.dialog.y = 323;
        this.addChild(this.dialog);
    }
    onMouseDown(){
        this.GameView.down();
    }
    onMouseUp(){
        this.GameView.up();
    }
    onGameComplete(){
        console.log('死亡');
        this.removeListener();
        let score = this.getScore();
        engine.globalEvent.dispatchEvent('walking-cat-game-end',{score:score});
    }
    getScore(round = false) {
		let score = (this.normalScore + this.rewardScore) / 10;
		score *= (props.scoreTimes || 1);
		if (round) {
			return Math.round(score);
		}
		return score;
	}
    onScoreChange(event){
        const {score, passType, rewardScore} = event.data;
        
		let scoreAdd;

		if (rewardScore) {
			this.rewardScore += rewardScore;
			scoreAdd = rewardScore;
		} else {
			scoreAdd = score - this.normalScore;
			this.normalScore = score;
        }
        let curScore = this.getScore();
        this.labScore.updateScore(curScore, this.formatScore);

        if (passType > 0 && passType <= 4) {
			const now = Date.now();
			if (now - this.lastDialogTs > 15000) {
				this.play(1);
                this.lastDialogTs = now;
                
			}
		} else if (passType == 10) {
			this.play(0);
            this.lastDialogTs = Date.now();
            this.GameView.setWitchFace('happy');
		}

		if (scoreAdd > 0) {
            const labScoreAdd = this.addlabelScore;
			labScoreAdd.visible = props.showScore;
			labScoreAdd.alpha = 0;
			labScoreAdd.verticalCenter = 0;
			labScoreAdd.text = '+' + (scoreAdd / 10 * (props.scoreTimes || 1));
			engine.Tween.get(labScoreAdd, null, null, true)
				.to({verticalCenter: -50, alpha: 1,}, 200, engine.Ease.cubicIn)
				.wait(300)
				.to({verticalCenter: -100, alpha: 0,}, 100, engine.Ease.cubicOut)
				.call(function () {
					labScoreAdd.visible = false;
				}, this);
        }
        engine.globalEvent.dispatchEvent('walking-cat-game-changScore',{score:curScore});
    }
    formatScore = (s) => {
		let t = (Math.ceil(s * 10) / 10).toString();
		t += t.indexOf('.') < 0 ? '.0' : '';
		return t;
	};


    play(id){
		const img = this.dialog;
		img.texture = getTextureByName('dialog_'+id);
		img.scaleX = img.scaleY = 0;
		img.alpha = 1;
		img.visible = true;

		engine.Tween.get(img, null, null, true)
        .to({
            scaleX: 1, scaleY: 1
        }, 500, engine.Ease.backOut)
        .wait(500)
        .to({
            alpha: 0,
        }, 300)
        .call(()=>{
            img.visible = false;
        });
    }
    private  revive() {
		this.GameView.reset(true);
		this.GameView.start(true);
	}
}