import { props } from './../props';
/**
 * Created by rockyl on 2020-01-09.
 */

import GameView from "./GameView";
import {injectProps} from "../props";
import { PlayGame } from './PlayGame';

export class GameWrapper extends engine.Container {
	private _gameView: GameView;
	constructor() {
		super();
		engine.globalEvent.addEventListener('walking-cat-start', this.start, this);
		engine.globalEvent.addEventListener('walking-cat-revive', this.revive, this);
		engine.globalEvent.addEventListener('walking-cat-showScore', this.revive, this);
		

		let gameView = this._gameView = new GameView();
		this.addChild(gameView);
		//this.once(engine.Event.ADDED_TO_STAGE, this.start, this);
	}

	start(event: engine.Event) {
		injectProps(event.data);
		this._gameView.eventStart();
	}

	revive() {
		console.log('复活');
		this._gameView.reset(true);
		this._gameView.start(true);
	}

}
