/**
 * 障碍物
 */
import {getStage, getTextureByName} from "./utils";
export class Block extends engine.Container {

	static configs = [
		{ratio: 0.6, width: 15, off: 32, effect: '', effect_offset: {x: 0, y: 0}},
		{ratio: 0.1, width: 10, off: 18, effect: '', effect_offset: {x: 0, y: 0}},
		{ratio: 0.15, width: 30, off: 32, effect: '', effect_offset: {x: 0, y: 0}},
		{ratio: 0.1, width: 86, off: 28, effect: '', effect_offset: {x: 0, y: 0}},
		{ratio: 0.5, width: 70, off: 20, effect: '', effect_offset: {x: 0, y: -20}},
		{ratio: 0, width: 0, off: 0, effect: '', effect_offset: {x: 0, y: 0}},
		{ratio: 0, width: 0, off: 0, effect: '', effect_offset: {x: 0, y: 0}},
		{ratio: 0, width: 0, off: 0, effect: '', effect_offset: {x: 0, y: 0}},
		{ratio: 0, width: 0, off: 0, effect: '', effect_offset: {x: 0, y: 0}},
		{ratio: 0, width: 0, off: 0, effect: '', effect_offset: {x: 0, y: 0}},
		{ratio: 0, width: 123, off: 23, effect: '', effect_offset: {x: 0, y: 0}},
	];

	type;
	bmp;
	//effectMC: engine.MovieClip;

	effectResolve;

	constructor() {
		super();

		this.bmp = new engine.Sprite();
		this.addChild(this.bmp = new engine.Sprite());
    }
    //
	reset({type,}) {
		this.type = type;

		let bmp = this.bmp;
		bmp.alpha = 1;
		bmp.texture = this.getBlock();
		const {width, off} = Block.configs[type];
		bmp.x = -(off + width / 2);
		bmp.y = -(bmp.height / 2);
    }
    getBlock(){
        return getTextureByName('block_' + this.type);
    }
	playEffect() {
		//const {effect, effect_offset} = Block.configs[this.type];
		// if (effect) {
		// 	if (!this.effectMC) {
		// 		const mc = this.effectMC = Effects.instance.makeMovieClip(effect);
		// 		const {x, y} = effect_offset;
		// 		mc.x = x;
		// 		mc.y = y;
		// 		this.addChild(mc);
		// 		mc.addEventListener(egret.Event.COMPLETE, this.onEffectComplete, this);
		// 	}
		// 	this.effectMC.gotoAndPlay(0, 1);
		// 	return new Promise(resolve => {
		// 		this.effectResolve = resolve;
		// 	})
		// } else {
		// 	return Promise.resolve();
		// }
	}

	playFadeOut() {

		return this.getTweenPromise(
	        engine.Tween.get(this.bmp)
        .to({alpha: 0}, 100)
        .to({alpha: 1}, 100)
        .to({alpha: 0}, 100)
		)
	}

	private onEffectComplete(event) {
		this.effectResolve && this.effectResolve();
		this.effectResolve = null;
    }
    getTweenPromise(tween: engine.Tween): Promise<any> {
        return new Promise((resolve) => {
            tween.call(resolve);
        });
    }
}
