
import {getTextureByName} from "./utils";
import {LoopComponent} from "./LoopComponent";
import {getStage} from "./utils";
import {props} from "../props";

export class Background extends engine.Container {
    //static stageWidth = engine.gameStage.stage.width;
    partRes = ['bg_far', 'bg_mid', 'bg_near'];
	speeds = [0.05, 0.5, 1];
	setup() {
        let bottomBg = new engine.Rect();
        bottomBg.x = 0;
        bottomBg.y = 0;
        bottomBg.width = getStage().width;
        bottomBg.height = 0;
        bottomBg.fillColor = 0x75c9f5;

		this.addChild(bottomBg);

		const parts = [];
		for(let i = 0; i < 3; i++){
			let part = new LoopComponent();
			part.setupLoop([
				this.partRes[i],
				this.partRes[i],
			]);
			parts.push(part);
			this.addChild(part);
		}

		const {height} = getStage();
		parts[0].y = (height - parts[0].height) / 2 - 400;
		parts[1].y = (height - parts[1].height) / 2 - 120;
		parts[2].y = (height - parts[2].height) / 2 + 300;

		bottomBg.y = parts[2].y;
        bottomBg.height = height - parts[2].y;
        
        const moon = new engine.Sprite(getTextureByName('moon'));
		moon.x = 100;
        moon.y = 100;
        this.addChild(moon);
    }
    setViewport(pos) {
		for (let i = 0; i < 3; i++) {
			const part = <LoopComponent>this.getChildAt(i + 1);
			const speed = this.speeds[i];

			part.setViewport(pos * speed)
		}
    }
    reset(revive = false){

	}

}
