
import { getTextureByName, createSvga } from './utils';
import { props } from "../props";

export default class Gameinit extends engine.Container {

    private _isSetUp = false;
    private isYes = true;
    private num = -1;
    private isDid = true;
    _body: engine.Rect;
    /**cardW,cardH,intervalX,intervalY */
    constructor() {
        super();
        this.once(engine.Event.ADDED_TO_STAGE, this.setup, this);
    }
    /**首页加载 */
    setup() {
        if (this._isSetUp) {
            return;
        }
        else {
            this.loadinit();
        }
    }
    /**套圈资源加载 */
    loadinit() {
        let self = this;
        let body;
        body = this._body = new engine.Rect;
        body.width = 0.0001;
        body.height = 0.0001;
        this.addChild(body);
        this.loadCard0(body, props.totleCardCount, props.eachLineCardCount, props.eachCardWidth, props.eachCardHeight, props.intervalX, props.inervalY);
        let [v2X, v2Y] = props.turnCardModuleGlobalPosition;
        body.x = v2X;
        body.y = v2Y;
        console.log("*******", props.eachLineCardCount * (props.eachCardWidth + props.intervalX), props.totleCardCount / props.eachLineCardCount * (props.eachCardHeight + props.inervalY), "*********");
        console.log('》》》》》', body.children.length, '《《《《《');
        /********************************/
        // let btn = this.addRes(body, "牌子", 300, 800, 50, 50);
        // btn.addEventListener(engine.MouseEvent.MOUSE_DOWN, function () {
        //     self.randomTurnCard(body);
        // }, this);
        // let btn1 = this.addRes(body, "牌子", 600, 800, 70, 70);
        // btn1.addEventListener(engine.MouseEvent.MOUSE_DOWN, function () {
        //     // this.randomTurnCard(body);
        //     console.log("000");
        //     body.children[this.num].scaleX = 1;
        //     self.isYes = true;
        //     // self.isDid = true;
        // }, this);
        /*********************************/
        engine.globalEvent.addEventListener("turn-card-game-start", function () {
            self.randomTurnCard(body);
        });
        engine.globalEvent.addEventListener("turn-card-game-init", function () {
            console.log("000");
            body.children[this.num].scaleX = 1;
            self.isYes = true;
        });
    }
    /**随机进行翻牌子 */
    randomTurnCard(bodyNode) {
        console.log("click");
        if (this.isYes) {
            this.num = Math.floor(Math.random() * (bodyNode.children.length));
            console.log("num====", this.num, '=====');
            console.log("fatherNode[num]==", bodyNode.children[this.num]);
            this.aniCardTurn(bodyNode.children[this.num], this.isDid), this.isYes = false;
        }
    }
    /** loading card */
    loadCard0(fatherNode, count, eachLine, cardW, cardH, intervalX, intervalY) {
        //let card0 = this.addRes(fatherNode, "牌子", 0, 0, 163, 184,30,10);
        let card;
        for (let j = 0; j < count / eachLine; j++) {
            for (let i = 0; i < eachLine; i++) {
                card = this.addRes(fatherNode, "牌子", (cardW + intervalX) * i, (cardH + intervalY) * j, cardW, cardH);
                card.anchor.x = cardW / 2;
                card.anchor.y = cardH / 2;
                //点击翻牌子的情况**************
                // card.addEventListener(engine.MouseEvent.MOUSE_DOWN, this.aniCardTurn)
            }
        }
        return card;
    }
    /**给场景添加图片,resName:资源名字，v2X：资源X位置, v2Y：资源Y位置, resW：资源Width, resH:资源Height */
    addRes(fatherNode, resName, v2X, v2Y, resW, resH) {
        console.log("进行资源的添加");
        let thing = new engine.Sprite(getTextureByName(resName));
        thing.x = v2X;
        thing.y = v2Y;
        thing.width = resW;
        thing.height = resH;
        return fatherNode.addChild(thing);
    }
    /** card turn */
    aniCardTurn(turnNode, bool) {
        // console.log(']]]]]', turnNode);
        turnNode.addEventListener(engine.Event.ENTER_FRAME, function () {
            if (bool) {
                if (turnNode.scaleX >= 0.1 && turnNode.scaleX <= 1) {
                    turnNode.scaleX -= 0.03;
                    console.log("动画未完成  bool==", bool);
                }
                else {
                    console.log("bool", bool);
                    console.log("00000000000000");
                    bool = false;
                    engine.globalEvent.dispatchEvent("turn-card-game-end");
                }
            }
        });
    }
}
