(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('tslib')) :
	typeof define === 'function' && define.amd ? define(['tslib'], factory) :
	(global = global || self, global['turn-card'] = factory(global.tslib));
}(this, (function (tslib) { 'use strict';

	function getTexture(uuid) {
	    return engine.Texture.from(getAssetByUUID(uuid).uuid);
	}
	function getTextureByName(name) {
	    console.log('name', engine.getAssetByName(name));
	    return getTexture(engine.getAssetByName(name).uuid);
	}
	//# sourceMappingURL=utils.js.map

	var props = {};
	function prepareProps() {
	    var metaProps = getProps();
	    engine.injectProp(props, metaProps);
	}
	function injectProps(p) {
	    engine.injectProp(props, p);
	}
	//# sourceMappingURL=props.js.map

	var Gameinit = (function (_super) {
	    tslib.__extends(Gameinit, _super);
	    function Gameinit() {
	        var _this = _super.call(this) || this;
	        _this._isSetUp = false;
	        _this.isYes = true;
	        _this.num = -1;
	        _this.isDid = true;
	        _this.once(engine.Event.ADDED_TO_STAGE, _this.setup, _this);
	        return _this;
	    }
	    Gameinit.prototype.setup = function () {
	        if (this._isSetUp) {
	            return;
	        }
	        else {
	            this.loadinit();
	        }
	    };
	    Gameinit.prototype.loadinit = function () {
	        var self = this;
	        var body;
	        body = this._body = new engine.Rect;
	        body.width = 0.0001;
	        body.height = 0.0001;
	        this.addChild(body);
	        this.loadCard0(body, props.totleCardCount, props.eachLineCardCount, props.eachCardWidth, props.eachCardHeight, props.intervalX, props.inervalY);
	        var _a = props.turnCardModuleGlobalPosition, v2X = _a[0], v2Y = _a[1];
	        body.x = v2X;
	        body.y = v2Y;
	        console.log("*******", props.eachLineCardCount * (props.eachCardWidth + props.intervalX), props.totleCardCount / props.eachLineCardCount * (props.eachCardHeight + props.inervalY), "*********");
	        console.log('》》》》》', body.children.length, '《《《《《');
	        engine.globalEvent.addEventListener("turn-card-game-start", function () {
	            self.randomTurnCard(body);
	        });
	        engine.globalEvent.addEventListener("turn-card-game-init", function () {
	            console.log("000");
	            body.children[this.num].scaleX = 1;
	            self.isYes = true;
	        });
	    };
	    Gameinit.prototype.randomTurnCard = function (bodyNode) {
	        console.log("click");
	        if (this.isYes) {
	            this.num = Math.floor(Math.random() * (bodyNode.children.length));
	            console.log("num====", this.num, '=====');
	            console.log("fatherNode[num]==", bodyNode.children[this.num]);
	            this.aniCardTurn(bodyNode.children[this.num], this.isDid), this.isYes = false;
	        }
	    };
	    Gameinit.prototype.loadCard0 = function (fatherNode, count, eachLine, cardW, cardH, intervalX, intervalY) {
	        var card;
	        for (var j = 0; j < count / eachLine; j++) {
	            for (var i = 0; i < eachLine; i++) {
	                card = this.addRes(fatherNode, "牌子", (cardW + intervalX) * i, (cardH + intervalY) * j, cardW, cardH);
	                card.anchor.x = cardW / 2;
	                card.anchor.y = cardH / 2;
	            }
	        }
	        return card;
	    };
	    Gameinit.prototype.addRes = function (fatherNode, resName, v2X, v2Y, resW, resH) {
	        console.log("进行资源的添加");
	        var thing = new engine.Sprite(getTextureByName(resName));
	        thing.x = v2X;
	        thing.y = v2Y;
	        thing.width = resW;
	        thing.height = resH;
	        return fatherNode.addChild(thing);
	    };
	    Gameinit.prototype.aniCardTurn = function (turnNode, bool) {
	        turnNode.addEventListener(engine.Event.ENTER_FRAME, function () {
	            if (bool) {
	                if (turnNode.scaleX >= 0.1 && turnNode.scaleX <= 1) {
	                    turnNode.scaleX -= 0.03;
	                    console.log("动画未完成  bool==", bool);
	                }
	                else {
	                    console.log("bool", bool);
	                    console.log("00000000000000");
	                    bool = false;
	                    engine.globalEvent.dispatchEvent("turn-card-game-end");
	                }
	            }
	        });
	    };
	    return Gameinit;
	}(engine.Container));
	//# sourceMappingURL=Gameinit.js.map

	function index (props) {
	    prepareProps();
	    injectProps(props);
	    var instance = new Gameinit();
	    return instance;
	}
	//# sourceMappingURL=index.js.map

	return index;

})));

//# sourceMappingURL=main.js.map