
import {props} from '../props'
import {getTexture,getTextureByName} from './utils'
// import {Ball} from './Ball';
import {Bullets} from './Bullets';

export default class GameView extends engine.Container{
    startBtn:engine.Sprite
    stageBg: engine.Sprite;
    planeModel:engine.Sprite;
    pictureWrapper: engine.Sprite;
    gameBg: engine.Sprite;
    bullet: engine.Sprite;
    ball:engine.Sprite;
    
    constructor(){
        super()
        this.once(engine.Event.ADDED_TO_STAGE, this.setup, this);
    }
    
    setup(){
        this.stageBg = new engine.Sprite(getTexture('308742a0-0ea2-4610-b34a-a230add82021'))
        this.addChild(this.stageBg)

        this.gameBg = new engine.Sprite(getTexture('76820072-df5a-4ab7-8cb7-10c8cd8605c8'))
        
        this.bullet = new engine.Sprite(getTexture('18852543-1f1d-498b-af64-88cd3b343758'))
        
        // 开始按钮
        this.startBtn = new engine.Sprite(getTexture('855e3d77-ffff-443d-b884-4f67a2ebe458'))
        this.startBtn.x = (750 - this.startBtn.width) / 2;
        this.startBtn.y = (this.stage.height - this.startBtn.height) / 2 + 300;
        this.stageBg.addChild(this.startBtn)
        this.startBtn.addEventListener(engine.MouseEvent.CLICK,this.onClick,this)
    }

    mouseX;
    mouseY;
    planeCenterX;
    centerX

    ballArray:engine.Sprite[] = []
    bulletArray:engine.Sprite[] = []

    // baller:Ball
    bulleter:Bullets
    ballerArray:any[] = []
    bulletsArray:any[] = []

    score:number = 0

    start(){
        // 炮车
        this.planeModel = new engine.Sprite(getTexture('32ec481a-3f75-4c36-95ed-ee97aa936517'))
        this.planeModel.x = (750 - this.planeModel.width) / 2;
        this.planeModel.y = (this.stage.height - this.planeModel.height)
        this.planeModel.addEventListener(engine.MouseEvent.MOUSE_DOWN,this.onDown,this)

        // 子弹
        // this.bullet.x = 375;
        // this.bullet.y = 1150
        this.gameBg.addChild(this.planeModel)

        let boom = new engine.Sprite(getTexture('38ec6627-efa8-4f7a-9bdc-3c73cea717f1'))

        // 计分
        
        
        // 敌机

        setInterval(()=>{

            let ball = new engine.Sprite(getTexture('780b6b63-3abd-4246-94ba-2a3fbdb3c5af'));
            ball.x = Math.random() * (750 - ball.width ) ;
            ball.y = Math.random() * (ball.height);
            let life = 5
            this.ballerArray.push({ball,life})
            this.gameBg.addChild(ball)

        },500)
        // 敌机移动
        // setInterval(()=>{
        //     let index
        //     for(let ball of this.ballerArray){
        //         // ball.x += Math.random() * (40) + (-20);
        //         ball.y += 1;
        //         if(ball.y > this.stage.height){
        //             this.gameBg.removeChild(ball)
        //             index = this.ballerArray.indexOf(ball)
        //             this.ballerArray = this.ballerArray.filter((ele,i)=>i != index)
        //         }
        //     }

        // },16)

        // 添加生命值
        setInterval(()=>{
            let index
            for(let ballObj of this.ballerArray){
                // ball.x += Math.random() * (40) + (-20); 
                ballObj.ball.y += 1;
                if(ballObj.ball.y > this.stage.height){
                    this.gameBg.removeChild(ballObj.ball)
                    index = this.ballerArray.indexOf(ballObj)
                    this.ballerArray = this.ballerArray.filter((ele,i)=>i != index)
                }
            }

        },16)


        // 子弹
        setInterval(()=>{
            let bullet = new engine.Sprite(getTexture('18852543-1f1d-498b-af64-88cd3b343758'))
            bullet.x = this.planeModel ? this.planeModel.x + this.planeModel.width / 2 - bullet.width / 2 : 375 - bullet.width / 2 ;
            bullet.y = 1150
            

            let harm = 1;
            this.bulletsArray.push({bullet,harm});

            this.gameBg.addChild(bullet)

        },100)
        // 子弹移动

        // 计算伤害


        // 碰撞
        // setInterval(()=>{

        //     for(let bullet of this.bulletsArray){
        //         console.log(this.ballerArray)
        //         console.log(this.bulletsArray)
        //         console.log("===================");
                
        //         bullet.y -= 40;
        //         if(bullet.y < -40){
        //             this.gameBg.removeChild(bullet)
        //             let index = this.bulletsArray.indexOf(bullet)
        //             this.bulletsArray = this.bulletsArray.filter((ele,i)=>i != index)
        //         }

        //         for(let baller of this.ballerArray){
        //             let y = bullet.y - baller.y;
        //             let bulletRight = bullet.x + bullet.width;
        //             if(bulletRight > baller.x && bulletRight < (baller.x + baller.width) || bullet.x > baller.x && bullet.x < (baller.x + baller.width)){
        //                 if(y <= 0){
        //                     // 击中  移除敌机
        //                     this.gameBg.removeChild(bullet)
        //                     let index = this.bulletsArray.indexOf(bullet)
        //                     this.bulletsArray = this.bulletsArray.filter((ele,i)=>i != index)
                            
        //                     boom.x = baller.x;
        //                     boom.y = baller.y;
        //                     this.gameBg.addChild(boom)
        //                     this.gameBg.removeChild(baller)
        //                     let ind = this.ballerArray.indexOf(baller)
        //                     this.ballerArray = this.ballerArray.filter((ele,i)=>i != ind)
        //                     setTimeout(() => {
        //                         this.gameBg.removeChild(boom);
        //                     }, 1500);
        //                 }
        //             }
        //         }
        //     }

        // },20)



        setInterval(()=>{

            for(let bulletObj of this.bulletsArray){
                console.log(this.ballerArray)
                console.log(this.bulletsArray)
                console.log("得分："+this.score)
                console.log("===================");
                
                bulletObj.bullet.y -= 40;
                if(bulletObj.bullet.y < -40){
                    this.gameBg.removeChild(bulletObj.bullet)
                    let index = this.bulletsArray.indexOf(bulletObj)
                    this.bulletsArray = this.bulletsArray.filter((ele,i)=>i != index)
                }

                for(let ballObj of this.ballerArray){
                    let y = bulletObj.bullet.y - ballObj.ball.y;
                    let bulletRight = bulletObj.bullet.x + bulletObj.bullet.width;
                    if(bulletRight > ballObj.ball.x && bulletRight < (ballObj.ball.x + ballObj.ball.width) || bulletObj.bullet.x > ballObj.ball.x && bulletObj.bullet.x < (ballObj.ball.x + ballObj.ball.width)){
                        if(y <= 0){
                            // 击中  移除敌机
                            ballObj.life -= bulletObj.harm;

                            // 加分
                            this.score += bulletObj.harm;
                            // console.log("得分："+this.score)

                            //子弹移除
                            this.gameBg.removeChild(bulletObj.bullet)
                            let index = this.bulletsArray.indexOf(bulletObj)
                            this.bulletsArray = this.bulletsArray.filter((ele,i)=>i != index)

                            if(ballObj.life === 0){
                                this.gameBg.removeChild(ballObj.ball)
                                let ind = this.ballerArray.indexOf(ballObj)
                                this.ballerArray = this.ballerArray.filter((ele,i)=>i != ind)
                                
                                boom.x = ballObj.ball.x;
                                boom.y = ballObj.ball.y;
                                this.gameBg.addChild(boom)

                                setTimeout(() => {
                                    this.gameBg.removeChild(boom);
                                }, 1500);
                            }
                            
                        }
                    }
                }
            }

        },20)

    }
    stop(){}

    onDown(e){
        this.mouseX = e.localX
        this.mouseY = e.localY
        this.stage.addEventListener(engine.MouseEvent.MOUSE_MOVE,this.onMove,this)

        this.planeModel.x = e.stageX - this.mouseX;
        this.planeCenterX = this.planeModel.x + this.planeModel.width / 2;

    }

    onMove(e:engine.MouseEvent){
        // 以图片中心为准
        this.centerX = this.planeModel.width / 2;
        let movedCenter = this.centerX + e.stageX - this.mouseX;
        if(movedCenter < 0){
            this.planeModel.x = -this.centerX;
        } else if(movedCenter >750){
            this.planeModel.x = 750 - this.centerX;
        } else {
            this.planeModel.x = e.stageX - this.mouseX;
            this.planeCenterX = this.planeModel.x + this.planeModel.width / 2;
            // console.log(e.stageX,e.stageY)

        }

    }

    onClick(){
        this.addChild(this.gameBg);
        this.gameBg.addChild(this.planeModel)

        
    }

    shoot(w){
        setInterval(()=>{
            let bullet = new engine.Sprite(getTexture('18852543-1f1d-498b-af64-88cd3b343758'));
            bullet.x = this.planeModel.x && this.planeModel.x + this.centerX - this.bullet.width / 2 + w || 375 - this.bullet.width / 2 + w;
            bullet.y = 1150
            this.gameBg.addChild(bullet)

            this.bullet.y = this.bullet.y - 40;
            let timeid = setInterval(()=>{
                bullet.y = bullet.y - 40;
                if(bullet.y < -40){
                    this.gameBg.removeChild(bullet)
                    clearInterval(timeid)
                }
            },1000/60)

        },1000/60)
    }

    // ball:engine.Sprite;

    drop(){
        let ball = new engine.Sprite(getTexture('780b6b63-3abd-4246-94ba-2a3fbdb3c5af'));
        ball.x = Math.random() * (750 - ball.width ) + ball.width;
        ball.y = Math.random() * (ball.height)
        
        this.gameBg.addChild(ball)

        setInterval(()=>{
            ball.y += 1;
            if(ball.y > this.stage.height){
                this.gameBg.removeChild(ball)
            }

        },50)

    }

}